/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.LocatorProcessing;
import io.perfeccionista.framework.exceptions.SingleResultConversion;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.operation.WebLocatorProcessingResult;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementOperationResult<T> {
    protected WebExceptionMapper exceptionMapper;
    protected RuntimeException exception;
    protected final Map<String, Map<Integer, WebLocatorProcessingResult>> searchHistory;
    protected final Map<Integer, T> values;
    protected final String pageSource;

    protected WebElementOperationResult(Map<String, Map<Integer, WebLocatorProcessingResult>> searchHistory, Map<Integer, T> values, WebExceptionMapper exceptionMapper, RuntimeException exception, String pageSource) {
        this.searchHistory = searchHistory;
        this.values = values;
        this.exceptionMapper = exceptionMapper;
        this.exception = exception;
        this.pageSource = pageSource;
    }

    public static <T> WebElementOperationResult<T> of(@NotNull Map<String, Map<Integer, WebLocatorProcessingResult>> searchHistory, @NotNull Map<Integer, T> values, @NotNull String pageSource) {
        return new WebElementOperationResult<T>(searchHistory, values, null, null, pageSource);
    }

    public static <T> WebElementOperationResult<T> of(@NotNull Map<String, Map<Integer, WebLocatorProcessingResult>> searchHistory, @NotNull WebExceptionMapper exceptionMapper, @NotNull RuntimeException exception, @NotNull String pageSource) {
        return new WebElementOperationResult(searchHistory, new HashMap(), exceptionMapper, exception, pageSource);
    }

    public static <T> WebElementOperationResult<T> of(@NotNull WebExceptionMapper exceptionMapper, @NotNull RuntimeException exception) {
        return new WebElementOperationResult(new HashMap<String, Map<Integer, WebLocatorProcessingResult>>(), new HashMap(), exceptionMapper, exception, "empty");
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public WebElementOperationResult<T> ifSuccess(@NotNull Consumer<WebElementOperationResult<T>> action) {
        if (this.exception == null) {
            action.accept(this);
        }
        return this;
    }

    public WebElementOperationResult<T> ifException(@NotNull BiConsumer<? super WebExceptionMapper, ? super RuntimeException> action) {
        if (this.exception != null) {
            action.accept(this.exceptionMapper, this.exception);
        }
        return this;
    }

    public boolean hasResult() {
        return this.values.size() > 0;
    }

    @NotNull
    public T getNotNullResult() {
        if (this.values.size() > 1) {
            throw SingleResultConversion.exception((String)PageFactoryApiMessages.OPERATION_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Values", (JsonNode)this.valuesToJson()));
        }
        return (T)this.values.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow(() -> SingleResultConversion.exception((String)PageFactoryApiMessages.OPERATION_RESULT_HAS_NO_VALUE.getMessage(new Object[0])));
    }

    @Nullable
    public T getResult() {
        if (this.values.size() > 1) {
            throw SingleResultConversion.exception((String)PageFactoryApiMessages.OPERATION_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Values", (JsonNode)this.valuesToJson()));
        }
        return this.values.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public Map<Integer, T> getResults() {
        return this.values;
    }

    @Nullable
    public RuntimeException getException() {
        return this.exception;
    }

    @NotNull
    public String getPageSource() {
        return this.pageSource;
    }

    @NotNull
    public String getRequiredHash(@NotNull String locatorId) {
        WebLocatorProcessingResult locatorProcessingResult = this.getWebLocatorProcessingResult(locatorId).orElseThrow(() -> LocatorProcessing.exception((String)PageFactoryApiMessages.LOCATOR_PROCESSING_RESULT_NOT_FOUND.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Locator ID", (String)locatorId)));
        return locatorProcessingResult.getHash().orElseThrow(() -> LocatorProcessing.exception((String)PageFactoryApiMessages.LOCATOR_HASH_NOT_CALCULATED.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Locator Processing Result", (JsonNode)locatorProcessingResult.toJson())));
    }

    public Optional<WebLocatorProcessingResult> getWebLocatorProcessingResult(@NotNull String locatorId) {
        return this.getWebLocatorProcessingResult(locatorId, -1);
    }

    public Optional<WebLocatorProcessingResult> getWebLocatorProcessingResult(@NotNull String locatorId, int elementIndex) {
        return Optional.ofNullable(this.getWebLocatorProcessingResults(locatorId).get(elementIndex));
    }

    @NotNull
    protected Map<Integer, WebLocatorProcessingResult> getWebLocatorProcessingResults(String locatorId) {
        Map<Integer, WebLocatorProcessingResult> results = this.searchHistory.get(locatorId);
        if (results == null) {
            throw LocatorProcessing.exception((String)PageFactoryApiMessages.LOCATOR_PROCESSING_RESULT_NOT_FOUND.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Locator ID", (String)locatorId));
        }
        return results;
    }

    public JsonNode valuesToJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.values.forEach((key, value) -> rootNode.putPOJO(String.valueOf(key), value));
        return rootNode;
    }
}

