/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.type.WebElementOperationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementOperationHandler<T> {
    private final WebChildElementBase element;
    private final WebElementOperationType<T> operationType;
    private String component = null;

    private WebElementOperationHandler(WebChildElementBase element, WebElementOperationType<T> operationType) {
        this.element = element;
        this.operationType = operationType;
    }

    public static <T> WebElementOperationHandler<T> of(@NotNull WebChildElementBase element, @NotNull WebElementOperationType<T> operationType) {
        return new WebElementOperationHandler<T>(element, operationType);
    }

    public static <T> WebElementOperationHandler<T> of(@NotNull WebChildElementBase element, @NotNull WebElementOperationType<T> operationType, @Nullable String component) {
        WebElementOperationHandler<T> operationBuilder = new WebElementOperationHandler<T>(element, operationType);
        operationBuilder.setComponent(component);
        return operationBuilder;
    }

    public WebElementOperationHandler<T> setComponent(@Nullable String component) {
        this.component = component;
        return this;
    }

    public WebElementOperation<T> getOperation() {
        WebLocatorChain webLocatorChain = Objects.nonNull(this.component) ? this.element.getLocatorChainTo(this.component) : this.element.getLocatorChain();
        return WebElementOperation.of(webLocatorChain, this.operationType);
    }

    @NotNull
    public T executeGetter() {
        WebElementOperation<T> operation = this.getOperation();
        return this.element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            throw exceptionMapper.mapElementException(this.element, (RuntimeException)originalException).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
        }).getNotNullResult();
    }

    public void executeAction() {
        WebElementOperation<T> operation = this.getOperation();
        this.element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            throw exceptionMapper.mapElementException(this.element, (RuntimeException)originalException).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
        });
    }
}

