/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.pagefactory.operation.type.WebCustomOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebElementOperationType;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class WebElementOperation<R> {
    private final WebLocatorChain locatorChain;
    private final WebElementOperationType<R> operationType;
    private boolean withLogs = false;
    private boolean withPageSource = false;

    private WebElementOperation(WebLocatorChain locatorChain, WebElementOperationType<R> operationType) {
        this.locatorChain = locatorChain;
        this.operationType = operationType;
    }

    public static <R> WebElementOperation<R> of(@NotNull WebLocatorChain locatorChain, @NotNull WebElementOperationType<R> operationType) {
        return new WebElementOperation<R>(locatorChain, operationType);
    }

    public static <R> WebElementOperation<R> of(@NotNull WebLocatorChain locatorChain, @NotNull EndpointHandler<R> endpointHandler) {
        return new WebElementOperation<R>(locatorChain, WebCustomOperationType.of(endpointHandler));
    }

    public WebElementOperationType<R> getOperationType() {
        return this.operationType;
    }

    public WebLocatorChain getLocatorChain() {
        return this.locatorChain;
    }

    public WebElementOperation<R> updateLocatorChain(@NotNull Consumer<WebLocatorChain> webLocatorChainUpdater) {
        webLocatorChainUpdater.accept(this.locatorChain);
        return this;
    }

    public WebElementOperation<R> withPageSource() {
        this.withPageSource = true;
        return this;
    }

    public boolean isWithPageSource() {
        return this.withPageSource;
    }

    public WebElementOperation<R> withLogs() {
        this.withLogs = true;
        return this;
    }

    public List<EndpointHandler<?>> getRequiredFunctions() {
        ArrayList requiredFunctions = new ArrayList();
        this.locatorChain.getAllLocators().forEach(locatorHolder -> requiredFunctions.addAll(locatorHolder.getInvokeOnCallHandlers()));
        requiredFunctions.add(this.operationType.getEndpointHandler());
        return requiredFunctions;
    }

    public ObjectNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        rootNode.set("locatorChain", (JsonNode)this.locatorChain.toJson());
        rootNode.set("endpointFunction", this.operationType.getEndpointHandler().toJson());
        if (this.withLogs) {
            rootNode.put("withLogs", true);
        }
        if (this.withPageSource) {
            rootNode.put("withPageSource", true);
        }
        return rootNode;
    }
}

