/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsPresentAvailable;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementIsPresentOperationHandler {
    private final WebIsPresentAvailable element;
    private final WebGetIsPresentOperationType operationType;
    private String component = null;

    private WebElementIsPresentOperationHandler(WebIsPresentAvailable element, WebGetIsPresentOperationType operationType) {
        this.element = element;
        this.operationType = operationType;
    }

    public static WebElementIsPresentOperationHandler of(@NotNull WebIsPresentAvailable element, @NotNull WebGetIsPresentOperationType operationType) {
        return new WebElementIsPresentOperationHandler(element, operationType);
    }

    public static WebElementIsPresentOperationHandler of(@NotNull WebIsPresentAvailable element, @NotNull WebGetIsPresentOperationType operationType, @Nullable String component) {
        WebElementIsPresentOperationHandler operationBuilder = new WebElementIsPresentOperationHandler(element, operationType);
        operationBuilder.setComponent(component);
        return operationBuilder;
    }

    public WebElementIsPresentOperationHandler setComponent(@Nullable String component) {
        this.component = component;
        return this;
    }

    public WebElementOperation<Boolean> getOperation() {
        WebLocatorChain webLocatorChain = Objects.nonNull(this.component) ? this.element.getLocatorChainTo(this.component) : this.element.getLocatorChain();
        return WebElementOperation.of(webLocatorChain, this.operationType);
    }

    public boolean executeGetter() {
        WebElementOperation<Boolean> operation = this.getOperation();
        WebElementOperationResult<Boolean> operationResult = this.element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        if (operationResult.isSuccess()) {
            return operationResult.getResults().size() != 0;
        }
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(this.element, (RuntimeException)originalException);
            if (!(exception instanceof JsElementSearch)) {
                throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
        });
        return false;
    }
}

