/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.operation;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsDisplayedAvailable;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementIsDisplayedOperationHandler {
    private final WebIsDisplayedAvailable element;
    private final WebGetIsDisplayedOperationType operationType;
    private String component = null;

    private WebElementIsDisplayedOperationHandler(WebIsDisplayedAvailable element, WebGetIsDisplayedOperationType operationType) {
        this.element = element;
        this.operationType = operationType;
    }

    public static WebElementIsDisplayedOperationHandler of(@NotNull WebIsDisplayedAvailable element, @NotNull WebGetIsDisplayedOperationType operationType) {
        return new WebElementIsDisplayedOperationHandler(element, operationType);
    }

    public static WebElementIsDisplayedOperationHandler of(@NotNull WebIsDisplayedAvailable element, @NotNull WebGetIsDisplayedOperationType operationType, @Nullable String component) {
        WebElementIsDisplayedOperationHandler operationBuilder = new WebElementIsDisplayedOperationHandler(element, operationType);
        operationBuilder.setComponent(component);
        return operationBuilder;
    }

    public WebElementIsDisplayedOperationHandler setComponent(@Nullable String component) {
        this.component = component;
        return this;
    }

    public WebElementOperation<Boolean> getOperation() {
        WebLocatorChain webLocatorChain = Objects.nonNull(this.component) ? this.element.getLocatorChainTo(this.component) : this.element.getLocatorChain();
        return WebElementOperation.of(webLocatorChain, this.operationType);
    }

    public boolean executeGetter() {
        WebElementOperation<Boolean> operation = this.getOperation();
        WebElementOperationResult<Boolean> operationResult = this.element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        if (operationResult.isSuccess()) {
            int resultSize = operationResult.getResults().size();
            if (resultSize == 0) {
                return false;
            }
            return operationResult.getNotNullResult();
        }
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(this.element, (RuntimeException)originalException);
            if (!(exception instanceof JsElementSearch)) {
                throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
        });
        return false;
    }
}

