/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.limiter;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.SearchContextSizeMismatch;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilterBuilder;
import io.perfeccionista.framework.pagefactory.limiter.WebContextLimiter;
import io.perfeccionista.framework.value.number.NumberValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebTableCellContextLimiter<T extends WebBlock>
implements WebContextLimiter<T> {
    private final String columnName;
    private final String elementPath;
    private final WebTable elementFrame;
    private final WebTableFilterBuilder filterBuilder;
    private final NumberValue<Integer> expectedSize;

    private WebTableCellContextLimiter(String elementPath, WebTable elementFrame, String columnName, WebTableFilterBuilder filterBuilder, NumberValue<Integer> expectedSize) {
        this.elementPath = elementPath;
        this.elementFrame = elementFrame;
        this.columnName = columnName;
        this.filterBuilder = filterBuilder;
        this.expectedSize = expectedSize;
    }

    public static <T extends WebBlock> WebTableCellContextLimiter<T> of(@NotNull WebTable elementFrame, @NotNull String columnName, @NotNull WebTableFilterBuilder filterBuilder, @NotNull NumberValue<Integer> expectedSize) {
        return new WebTableCellContextLimiter<T>(null, elementFrame, columnName, filterBuilder, expectedSize);
    }

    public static <T extends WebBlock> WebTableCellContextLimiter<T> of(@NotNull String elementPath, @NotNull String columnName, @NotNull WebTableFilterBuilder filterBuilder, @NotNull NumberValue<Integer> expectedSize) {
        return new WebTableCellContextLimiter<T>(elementPath, null, columnName, filterBuilder, expectedSize);
    }

    @Override
    @NotNull
    public Stream<T> getContexts(@NotNull Stream<WebParentElement> parentElements) {
        Collection webBlocks = parentElements.map(parentElement -> {
            WebTable webTable = Objects.nonNull(this.elementFrame) ? parentElement.getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebTable.class) : parentElement.getElementRegistry().getRequiredElementByPath(this.elementPath, WebTable.class);
            return webTable.filter(this.filterBuilder).extractRows(Web.cell(this.columnName)).getResults().values();
        }).reduce(new ArrayList(), (webBlocks1, webBlocks2) -> {
            webBlocks1.addAll(webBlocks2);
            return webBlocks1;
        });
        if (!this.expectedSize.check((Object)webBlocks.size())) {
            throw SearchContextSizeMismatch.exception((String)PageFactoryApiMessages.SEARCH_CONTEXT_EXPECTED_SIZE_DOES_NOT_MATCH.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of(this.expectedSize));
        }
        return webBlocks.stream();
    }
}

