/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.limiter;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.SearchContextSizeMismatch;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterBuilder;
import io.perfeccionista.framework.pagefactory.limiter.WebContextLimiter;
import io.perfeccionista.framework.value.number.NumberValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebListBlockContextLimiter<T extends WebBlock>
implements WebContextLimiter<T> {
    private final String elementPath;
    private final WebList<T> elementFrame;
    private final WebListFilterBuilder<T> filterBuilder;
    private final NumberValue<Integer> expectedSize;

    private WebListBlockContextLimiter(String elementPath, WebList<T> elementFrame, WebListFilterBuilder<T> filterBuilder, NumberValue<Integer> expectedSize) {
        this.elementPath = elementPath;
        this.elementFrame = elementFrame;
        this.filterBuilder = filterBuilder;
        this.expectedSize = expectedSize;
    }

    public static <T extends WebBlock> WebListBlockContextLimiter<T> of(@NotNull WebList<T> elementFrame, @NotNull WebListFilterBuilder<T> filterBuilder, @NotNull NumberValue<Integer> expectedSize) {
        return new WebListBlockContextLimiter<T>(null, elementFrame, filterBuilder, expectedSize);
    }

    public static <T extends WebBlock> WebListBlockContextLimiter<T> of(@NotNull String elementPath, @NotNull WebListFilterBuilder<T> filterBuilder, @NotNull NumberValue<Integer> expectedSize) {
        return new WebListBlockContextLimiter<T>(elementPath, null, filterBuilder, expectedSize);
    }

    @Override
    @NotNull
    public Stream<T> getContexts(@NotNull Stream<WebParentElement> parentElements) {
        Collection webBlocks = parentElements.map(parentElement -> {
            WebList webList = Objects.nonNull(this.elementFrame) ? parentElement.getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebList.class) : parentElement.getElementRegistry().getRequiredElementByPath(this.elementPath, WebList.class);
            return webList.filter(block -> this.filterBuilder).extractAll(Web.block()).getResults().values();
        }).reduce(new ArrayList(), (webBlocks1, webBlocks2) -> {
            webBlocks1.addAll(webBlocks2);
            return webBlocks1;
        });
        if (!this.expectedSize.check((Object)webBlocks.size())) {
            throw SearchContextSizeMismatch.exception((String)PageFactoryApiMessages.SEARCH_CONTEXT_EXPECTED_SIZE_DOES_NOT_MATCH.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of(this.expectedSize));
        }
        return webBlocks.stream();
    }
}

