/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.texttable.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.DefaultWebTextBlock;
import io.perfeccionista.framework.pagefactory.elements.WebLink;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.texttable.condition.WebTextTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetTextOperationType;
import io.perfeccionista.framework.value.number.NumberValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextTableRowTextNumberValueCondition
implements WebTextTableRowCondition {
    private final Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> childConditions = new ArrayDeque<WebTextTableRowCondition.WebTextTableRowConditionHolder>();
    private final String columnName;
    private final NumberValue<?> expectedNumberValue;
    private boolean inverse = false;

    public WebTextTableRowTextNumberValueCondition(@NotNull String columnName, @NotNull NumberValue<?> expectedNumberValue) {
        this.columnName = columnName;
        this.expectedNumberValue = expectedNumberValue;
    }

    public WebTextTableRowTextNumberValueCondition containsTextCell() {
        return this;
    }

    public WebTextTableRowTextNumberValueCondition notContainTextCell() {
        return this.inverse();
    }

    @Override
    public WebTextTableRowCondition and(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTextTableRowCondition or(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTextTable element, @Nullable String hash) {
        WebTableFrame<DefaultWebTextBlock> webTableRegistry = element.getWebTextTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY")).addLastLocator(webTableRegistry.getRequiredBodyLocator(this.columnName));
        WebLink elementToFilter = webTableRegistry.getRequiredBodyMappedBlock(this.columnName).textLink();
        WebGetTextOperationType operationType = WebGetTextOperationType.of(elementToFilter);
        WebElementOperation<String> operation = WebElementOperationHandler.of(elementToFilter, operationType, "TEXT").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Map<Integer, String> textValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(textValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedNumberValue.checkString(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTextTableRowTextNumberValueCondition inverse() {
        this.inverse = true;
        return this;
    }
}

