/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.texttable.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.texttable.condition.WebTextTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import io.perfeccionista.framework.value.number.NumberValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextTableRowIndexCondition
implements WebTextTableRowCondition {
    private final Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> childConditions = new ArrayDeque<WebTextTableRowCondition.WebTextTableRowConditionHolder>();
    private final Integer expectedIndex;
    private final NumberValue<Integer> expectedValue;
    private boolean inverse = false;

    public WebTextTableRowIndexCondition(@NotNull Integer expectedIndex) {
        this.expectedIndex = expectedIndex;
        this.expectedValue = null;
    }

    public WebTextTableRowIndexCondition(@NotNull NumberValue<Integer> expectedValue) {
        this.expectedIndex = null;
        this.expectedValue = expectedValue;
    }

    public WebTextTableRowIndexCondition withTextRowIndex() {
        return this;
    }

    public WebTextTableRowIndexCondition withoutTextRowIndex() {
        return this.inverse();
    }

    @Override
    public WebTextTableRowCondition and(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTextTableRowCondition or(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTextTable element, @Nullable String hash) {
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY"));
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementOperation.of(tableLocatorChain, operationType);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Set<Integer> indexes = operationResult.getResults().keySet();
        Set<Integer> matches = this.getMatches(indexes);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Set<Integer> indexes) {
        HashSet<Integer> matches = new HashSet<Integer>();
        indexes.forEach(index -> {
            boolean check = this.expectedIndex != null ? this.expectedIndex.equals(index) : this.expectedValue.check(index);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)index);
            }
        });
        return matches;
    }

    private WebTextTableRowIndexCondition inverse() {
        this.inverse = true;
        return this;
    }
}

