/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.texttable.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.texttable.condition.WebTextTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextTableRowEmptyCondition
implements WebTextTableRowCondition {
    private final Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> childConditions = new ArrayDeque<WebTextTableRowCondition.WebTextTableRowConditionHolder>();
    private boolean inverse = false;

    public WebTextTableRowEmptyCondition allTextRows() {
        return this;
    }

    public WebTextTableRowEmptyCondition noTextRows() {
        return this.inverse();
    }

    @Override
    public WebTextTableRowCondition and(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTextTableRowCondition or(@NotNull WebTextTableRowCondition condition) {
        this.childConditions.add(WebTextTableRowCondition.WebTextTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTextTable element, @Nullable String hash) {
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY"));
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementOperation.of(tableLocatorChain, operationType);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Set<Integer> indexes = operationResult.getResults().keySet();
        if (this.inverse) {
            return FilterResult.of(new HashSet(), (String)calculatedHash);
        }
        return FilterResult.of(indexes, (String)calculatedHash);
    }

    private WebTextTableRowEmptyCondition inverse() {
        this.inverse = true;
        return this;
    }
}

