/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.texttable;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilter;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.texttable.condition.WebTextTableRowCondition;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextTableFilterImpl
implements WebTextTableFilter {
    private final WebTextTable element;
    private final WebTextTableFilterBuilder filterBuilder;
    private String initialHash = null;
    private FilterResult filterResult = null;

    private WebTextTableFilterImpl(WebTextTable element, WebTextTableFilterBuilder filterBuilder) {
        this.element = element;
        this.filterBuilder = filterBuilder;
    }

    public static WebTextTableFilterImpl of(@NotNull WebTextTable element, @NotNull WebTextTableFilterBuilder filterBuilder) {
        return new WebTextTableFilterImpl(element, filterBuilder);
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<String, WebTextTable> extractHeader(@NotNull String columnName) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textCellValue(columnName).fromHeader()).singleResult();
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<String, WebTextTable> extractRow(@NotNull String columnName) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textCellValue(columnName)).singleResult();
    }

    @Override
    @NotNull
    public <T> WebSingleIndexedResult<T, WebTextTable> extractRow(@NotNull WebTextTableValueExtractor<T> extractor) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor).singleResult();
    }

    @Override
    @NotNull
    public WebMultipleIndexedResult<String, WebTextTable> extractRows(@NotNull String columnName) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textCellValue(columnName));
    }

    @Override
    @NotNull
    public <T> WebMultipleIndexedResult<T, WebTextTable> extractRows(@NotNull WebTextTableValueExtractor<T> extractor) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor);
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<String, WebTextTable> extractFooter(@NotNull String columnName) {
        return WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textCellValue(columnName).fromFooter()).singleResult();
    }

    @Override
    @NotNull
    public WebTextTable getElement() {
        return this.element;
    }

    @Override
    @NotNull
    public FilterResult getFilterResult() {
        this.executeFilter(this.element, this.filterBuilder);
        return this.filterResult;
    }

    @Override
    public WebTextTableFilter should(@NotNull WebMultipleIndexedResultMatcher<Integer> matcher) {
        WebTextTableMultipleIndexedResult<Integer> indexedResult = WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textRowIndex());
        matcher.check(indexedResult);
        return this;
    }

    @Override
    public WebTextTableFilter setInitialHash(@Nullable String initialHash) {
        this.initialHash = initialHash;
        return this;
    }

    private void executeFilter(WebTextTable element, WebTextTableFilterBuilder filterBuilder) {
        Deque<WebTextTableFilterBuilder.WebTextTableRowFilterResultGroupingHolder> conditions = filterBuilder.getConditions();
        HashSet indexes = new HashSet();
        String calculatedHash = this.initialHash;
        for (WebTextTableFilterBuilder.WebTextTableRowFilterResultGroupingHolder conditionHolder : conditions) {
            WebTextTableRowCondition condition = conditionHolder.getCondition();
            FilterResult conditionResult = this.processConditions(element, condition, calculatedHash);
            calculatedHash = conditionResult.getHash();
            if (FilterResultGrouping.ADD == conditionHolder.getUsage()) {
                indexes.addAll(conditionResult.getIndexes());
            }
            if (FilterResultGrouping.SUBTRACT != conditionHolder.getUsage()) continue;
            indexes.removeAll(conditionResult.getIndexes());
        }
        this.filterResult = FilterResult.of(indexes, (String)calculatedHash);
    }

    private FilterResult processConditions(WebTextTable element, WebTextTableRowCondition condition, String hash) {
        FilterResult conditionResult = condition.process(element, hash);
        Deque<WebTextTableRowCondition.WebTextTableRowConditionHolder> childConditions = condition.getChildConditions();
        if (childConditions.isEmpty()) {
            return conditionResult;
        }
        String calculatedHash = conditionResult.getHash();
        HashSet<Integer> indexes = conditionResult.getIndexes();
        for (WebTextTableRowCondition.WebTextTableRowConditionHolder childConditionHolder : childConditions) {
            WebTextTableRowCondition childCondition = childConditionHolder.getCondition();
            FilterResult childConditionResult = this.processConditions(element, childCondition, calculatedHash);
            calculatedHash = childConditionResult.getHash();
            if (ConditionGrouping.AND == childConditionHolder.getUsage()) {
                HashSet<Integer> overallIndexes = new HashSet<Integer>();
                Iterator iterator = childConditionResult.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int childConditionIndex = (Integer)iterator.next();
                    if (!indexes.contains(childConditionIndex)) continue;
                    overallIndexes.add(childConditionIndex);
                }
                indexes = overallIndexes;
            }
            if (ConditionGrouping.OR != childConditionHolder.getUsage()) continue;
            indexes.addAll(childConditionResult.getIndexes());
        }
        return FilterResult.of((Set)indexes, (String)calculatedHash);
    }
}

