/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.textlist.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebLink;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.textlist.condition.WebTextListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetTextOperationType;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextListBlockTextStringValueCondition
implements WebTextListBlockCondition {
    private final Deque<WebTextListBlockCondition.WebTextListBlockConditionHolder> childConditions = new ArrayDeque<WebTextListBlockCondition.WebTextListBlockConditionHolder>();
    private final StringValue expectedStringValue;
    private boolean inverse = false;

    public WebTextListBlockTextStringValueCondition(@NotNull StringValue expectedStringValue) {
        this.expectedStringValue = expectedStringValue;
    }

    public WebTextListBlockTextStringValueCondition containsTextBlock() {
        return this;
    }

    public WebTextListBlockTextStringValueCondition notContainTextBlock() {
        return this.inverse();
    }

    @Override
    public WebTextListBlockTextStringValueCondition and(@NotNull WebTextListBlockCondition condition) {
        this.childConditions.add(WebTextListBlockCondition.WebTextListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTextListBlockTextStringValueCondition or(@NotNull WebTextListBlockCondition condition) {
        this.childConditions.add(WebTextListBlockCondition.WebTextListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTextListBlockCondition.WebTextListBlockConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTextList element, @Nullable String hash) {
        WebLink webTextLink = element.getWebTextListFrame().getMappedBlockFrame().textLink();
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebGetTextOperationType operationType = WebGetTextOperationType.of(webTextLink);
        WebElementOperation<String> operation = WebElementOperationHandler.of(webTextLink, operationType, "TEXT").getOperation();
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Map<Integer, String> textValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(textValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedStringValue.check(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTextListBlockTextStringValueCondition inverse() {
        this.inverse = true;
        return this;
    }
}

