/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.textlist.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.textlist.condition.WebTextListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextListBlockEmptyCondition
implements WebTextListBlockCondition {
    private final Deque<WebTextListBlockCondition.WebTextListBlockConditionHolder> childConditions = new ArrayDeque<WebTextListBlockCondition.WebTextListBlockConditionHolder>();
    private boolean inverse = false;

    public WebTextListBlockEmptyCondition allTextBlocks() {
        return this;
    }

    public WebTextListBlockEmptyCondition noTextBlocks() {
        return this.inverse();
    }

    @Override
    public WebTextListBlockEmptyCondition and(@NotNull WebTextListBlockCondition condition) {
        this.childConditions.add(WebTextListBlockCondition.WebTextListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTextListBlockEmptyCondition or(@NotNull WebTextListBlockCondition condition) {
        this.childConditions.add(WebTextListBlockCondition.WebTextListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTextListBlockCondition.WebTextListBlockConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTextList element, @Nullable String hash) {
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementOperation.of(listLocatorChain, operationType);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Set<Integer> indexes = operationResult.getResults().keySet();
        if (this.inverse) {
            return FilterResult.of(new HashSet(), (String)calculatedHash);
        }
        return FilterResult.of(indexes, (String)calculatedHash);
    }

    private WebTextListBlockEmptyCondition inverse() {
        this.inverse = true;
        return this;
    }
}

