/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.textlist;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilter;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.textlist.condition.WebTextListBlockCondition;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextListFilterImpl
implements WebTextListFilter {
    private final WebTextList element;
    private final WebTextListFilterBuilder filterBuilder;
    private String initialHash = null;
    private FilterResult filterResult = null;

    private WebTextListFilterImpl(WebTextList element, WebTextListFilterBuilder filterBuilder) {
        this.element = element;
        this.filterBuilder = filterBuilder;
    }

    public static WebTextListFilterImpl of(@NotNull WebTextList element, @NotNull WebTextListFilterBuilder filterBuilder) {
        return new WebTextListFilterImpl(element, filterBuilder);
    }

    @Override
    @API(status=API.Status.STABLE)
    @NotNull
    public WebSingleIndexedResult<String, WebTextList> extractOne() {
        return WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textBlockValue()).singleResult();
    }

    @Override
    @API(status=API.Status.STABLE)
    @NotNull
    public WebMultipleIndexedResult<String, WebTextList> extractAll() {
        return WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textBlockValue());
    }

    @Override
    @API(status=API.Status.INTERNAL)
    @NotNull
    public <T> WebSingleIndexedResult<T, WebTextList> extractOne(@NotNull WebTextListBlockValueExtractor<T> extractor) {
        return WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, extractor).singleResult();
    }

    @Override
    @API(status=API.Status.INTERNAL)
    @NotNull
    public <T> WebMultipleIndexedResult<T, WebTextList> extractAll(@NotNull WebTextListBlockValueExtractor<T> extractor) {
        return WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, extractor);
    }

    @Override
    @NotNull
    public WebTextList getElement() {
        return this.element;
    }

    @Override
    @NotNull
    public FilterResult getFilterResult() {
        this.executeFilter(this.element, this.filterBuilder);
        return this.filterResult;
    }

    @Override
    public WebTextListFilter should(@NotNull WebMultipleIndexedResultMatcher<Integer> matcher) {
        WebTextListMultipleIndexedResult<Integer> indexedResult = WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.textBlockIndex());
        matcher.check(indexedResult);
        return this;
    }

    @Override
    public WebTextListFilter setInitialHash(@Nullable String initialHash) {
        this.initialHash = initialHash;
        return this;
    }

    private void executeFilter(WebTextList element, WebTextListFilterBuilder filterBuilder) {
        Deque<WebTextListFilterBuilder.WebTextListBlockFilterResultGroupingHolder> conditions = filterBuilder.getConditions();
        HashSet indexes = new HashSet();
        String calculatedHash = this.initialHash;
        for (WebTextListFilterBuilder.WebTextListBlockFilterResultGroupingHolder conditionHolder : conditions) {
            WebTextListBlockCondition condition = conditionHolder.getCondition();
            FilterResult conditionResult = this.processConditions(element, condition, calculatedHash);
            calculatedHash = conditionResult.getHash();
            if (FilterResultGrouping.ADD == conditionHolder.getUsage()) {
                indexes.addAll(conditionResult.getIndexes());
            }
            if (FilterResultGrouping.SUBTRACT != conditionHolder.getUsage()) continue;
            indexes.removeAll(conditionResult.getIndexes());
        }
        this.filterResult = FilterResult.of(indexes, (String)calculatedHash);
    }

    private FilterResult processConditions(WebTextList element, WebTextListBlockCondition condition, String hash) {
        FilterResult conditionResult = condition.process(element, hash);
        Deque<WebTextListBlockCondition.WebTextListBlockConditionHolder> childConditions = condition.getChildConditions();
        if (childConditions.isEmpty()) {
            return conditionResult;
        }
        String calculatedHash = conditionResult.getHash();
        HashSet<Integer> indexes = conditionResult.getIndexes();
        for (WebTextListBlockCondition.WebTextListBlockConditionHolder childConditionHolder : childConditions) {
            WebTextListBlockCondition childCondition = childConditionHolder.getCondition();
            FilterResult childConditionResult = this.processConditions(element, childCondition, calculatedHash);
            calculatedHash = childConditionResult.getHash();
            if (ConditionGrouping.AND == childConditionHolder.getUsage()) {
                HashSet<Integer> overallIndexes = new HashSet<Integer>();
                Iterator iterator = childConditionResult.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int childConditionIndex = (Integer)iterator.next();
                    if (!indexes.contains(childConditionIndex)) continue;
                    overallIndexes.add(childConditionIndex);
                }
                indexes = overallIndexes;
            }
            if (ConditionGrouping.OR != childConditionHolder.getUsage()) continue;
            indexes.addAll(childConditionResult.getIndexes());
        }
        return FilterResult.of((Set)indexes, (String)calculatedHash);
    }
}

