/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.table.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsSelectedAvailable;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.condition.WebTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsSelectedOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableCellElementSelectedCondition
implements WebTableRowCondition {
    private final Deque<WebTableRowCondition.WebTableRowConditionHolder> childConditions = new ArrayDeque<WebTableRowCondition.WebTableRowConditionHolder>();
    private final String columnName;
    private final String elementPath;
    private final WebChildElement elementFrame;
    private boolean inverse = false;

    public WebTableCellElementSelectedCondition(@NotNull String columnName, @NotNull String elementPath) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
    }

    public WebTableCellElementSelectedCondition(@NotNull String columnName, @NotNull WebIsSelectedAvailable elementFrame) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = elementFrame;
    }

    public WebTableCellElementSelectedCondition selected() {
        return this;
    }

    public WebTableCellElementSelectedCondition notSelected() {
        return this.inverse();
    }

    @Override
    public WebTableRowCondition and(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTableRowCondition or(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTableRowCondition.WebTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTable element, @Nullable String hash) {
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY")).addLastLocator(webTableRegistry.getRequiredBodyLocator(this.columnName));
        WebIsSelectedAvailable elementToFilter = this.elementPath != null ? webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByPath(this.elementPath, WebIsSelectedAvailable.class) : webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebIsSelectedAvailable.class);
        WebGetIsSelectedOperationType operationType = WebGetIsSelectedOperationType.of(elementToFilter);
        WebElementOperation<Boolean> operation = WebElementOperationHandler.of(elementToFilter, operationType, "SELECTED").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Map<Integer, Boolean> selectedValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(selectedValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, Boolean> selectedValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        selectedValues.forEach((key, value) -> {
            if (value != null && (!this.inverse && value.booleanValue() || this.inverse && !value.booleanValue())) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTableCellElementSelectedCondition inverse() {
        this.inverse = true;
        return this;
    }
}

