/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.table.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.elements.methods.WebElementPropertyAvailable;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.condition.WebTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetStringAttributeValueOperationType;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableCellElementPropertyStringValueCondition
implements WebTableRowCondition {
    private final Deque<WebTableRowCondition.WebTableRowConditionHolder> childConditions = new ArrayDeque<WebTableRowCondition.WebTableRowConditionHolder>();
    private final String columnName;
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final String propertyName;
    private final StringValue expectedStringValue;
    private boolean inverse = false;

    public WebTableCellElementPropertyStringValueCondition(@NotNull String columnName, @NotNull String elementPath, @NotNull String propertyName, @NotNull StringValue expectedStringValue) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.propertyName = propertyName;
        this.expectedStringValue = expectedStringValue;
    }

    public WebTableCellElementPropertyStringValueCondition(@NotNull String columnName, @NotNull WebElementPropertyAvailable elementFrame, @NotNull String propertyName, @NotNull StringValue expectedStringValue) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = (WebChildElement)elementFrame;
        this.propertyName = propertyName;
        this.expectedStringValue = expectedStringValue;
    }

    public WebTableCellElementPropertyStringValueCondition containsProperty() {
        return this;
    }

    public WebTableCellElementPropertyStringValueCondition notContainProperty() {
        return this.inverse();
    }

    @Override
    public WebTableRowCondition and(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTableRowCondition or(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTableRowCondition.WebTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTable element, @Nullable String hash) {
        WebElementOperation<String> operation;
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY")).addLastLocator(webTableRegistry.getRequiredBodyLocator(this.columnName));
        WebChildElement elementToFilter = this.elementPath != null ? webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), this.elementFrame.getElementIdentifier().getElementType());
        Optional optionalPropertyHolder = elementToFilter.getProperty(this.propertyName);
        if (optionalPropertyHolder.isPresent()) {
            WebElementPropertyHolder propertyHolder = (WebElementPropertyHolder)optionalPropertyHolder.get();
            operation = propertyHolder.getOperation(elementToFilter);
        } else {
            WebGetStringAttributeValueOperationType operationType = WebGetStringAttributeValueOperationType.of(elementToFilter, this.propertyName);
            operation = WebElementOperationHandler.of(elementToFilter, operationType, this.propertyName).getOperation();
        }
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Map<Integer, String> propertyValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(propertyValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedStringValue.check(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTableCellElementPropertyStringValueCondition inverse() {
        this.inverse = true;
        return this;
    }
}

