/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.table.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsPresentAvailable;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.condition.WebTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsPresentOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableCellElementPresentCondition
implements WebTableRowCondition {
    private final Deque<WebTableRowCondition.WebTableRowConditionHolder> childConditions = new ArrayDeque<WebTableRowCondition.WebTableRowConditionHolder>();
    private final String columnName;
    private final String elementPath;
    private final WebChildElement elementFrame;
    private boolean inverse = false;

    public WebTableCellElementPresentCondition(@NotNull String columnName, @NotNull String elementPath) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
    }

    public WebTableCellElementPresentCondition(@NotNull String columnName, @NotNull WebIsPresentAvailable elementFrame) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = (WebChildElement)elementFrame;
    }

    public WebTableCellElementPresentCondition present() {
        return this;
    }

    public WebTableCellElementPresentCondition notPresent() {
        return this.inverse();
    }

    @Override
    public WebTableRowCondition and(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTableRowCondition or(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTableRowCondition.WebTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTable element, @Nullable String hash) {
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY")).addLastLocator(webTableRegistry.getRequiredBodyLocator(this.columnName));
        WebChildElement elementToFilter = this.elementPath != null ? webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), this.elementFrame.getElementIdentifier().getElementType());
        WebGetIsPresentOperationType isPresentOperationType = WebGetIsPresentOperationType.of(elementToFilter);
        WebElementOperation<Boolean> operation = WebElementIsPresentOperationHandler.of(elementToFilter, isPresentOperationType, "PRESENTED").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Map<Integer, Boolean> presentValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(presentValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, Boolean> presentValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        presentValues.forEach((key, value) -> {
            if (!this.inverse && value != null && value != false || this.inverse && value == null || this.inverse && !value.booleanValue()) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTableCellElementPresentCondition inverse() {
        this.inverse = true;
        return this;
    }
}

