/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.table.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetLabelAvailable;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.condition.WebTableRowCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetLabelOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableCellElementLabelTextCondition
implements WebTableRowCondition {
    private final Deque<WebTableRowCondition.WebTableRowConditionHolder> childConditions = new ArrayDeque<WebTableRowCondition.WebTableRowConditionHolder>();
    private final String columnName;
    private final String elementPath;
    private final WebGetLabelAvailable elementFrame;
    private final String expectedText;
    private boolean inverse = false;

    public WebTableCellElementLabelTextCondition(@NotNull String columnName, @NotNull String elementPath, @NotNull String expectedText) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.expectedText = expectedText;
    }

    public WebTableCellElementLabelTextCondition(@NotNull String columnName, @NotNull WebGetLabelAvailable elementFrame, @NotNull String expectedText) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.expectedText = expectedText;
    }

    public WebTableCellElementLabelTextCondition containsLabel() {
        return this;
    }

    public WebTableCellElementLabelTextCondition notContainLabel() {
        return this.inverse();
    }

    @Override
    public WebTableRowCondition and(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebTableRowCondition or(@NotNull WebTableRowCondition condition) {
        this.childConditions.add(WebTableRowCondition.WebTableRowConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebTableRowCondition.WebTableRowConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebTable element, @Nullable String hash) {
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        tableLocatorChain.addLastLocator(element.getRequiredLocator("TBODY")).addLastLocator(webTableRegistry.getRequiredBodyLocator(this.columnName));
        WebGetLabelAvailable elementToFilter = this.elementPath != null ? webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByPath(this.elementPath, WebGetLabelAvailable.class) : webTableRegistry.getRequiredBodyMappedBlock(this.columnName).getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebGetLabelAvailable.class);
        WebGetLabelOperationType operationType = WebGetLabelOperationType.of(elementToFilter);
        WebElementOperation<String> operation = WebElementOperationHandler.of(elementToFilter, operationType, "LABEL").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(tableLocatorHolder.getLocatorId());
        Map<Integer, String> labelValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(labelValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedText.equals(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebTableCellElementLabelTextCondition inverse() {
        this.inverse = true;
        return this;
    }
}

