/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.table;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilter;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.table.condition.WebTableRowCondition;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableFilterImpl
implements WebTableFilter {
    private final WebTable element;
    private final WebTableFilterBuilder filterBuilder;
    private String initialHash = null;
    private FilterResult filterResult = null;

    private WebTableFilterImpl(WebTable element, WebTableFilterBuilder filterBuilder) {
        this.element = element;
        this.filterBuilder = filterBuilder;
    }

    public static WebTableFilterImpl of(@NotNull WebTable element, @NotNull WebTableFilterBuilder filter) {
        return new WebTableFilterImpl(element, filter);
    }

    @Override
    @NotNull
    public <T> WebSingleIndexedResult<T, WebTable> extractHeader(@NotNull WebTableValueExtractor<T> extractor) {
        return WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor.fromHeader()).singleResult();
    }

    @Override
    @NotNull
    public <T> WebSingleIndexedResult<T, WebTable> extractRow(@NotNull WebTableValueExtractor<T> extractor) {
        return WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor).singleResult();
    }

    @Override
    @NotNull
    public <T> WebMultipleIndexedResult<T, WebTable> extractRows(@NotNull WebTableValueExtractor<T> extractor) {
        return WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor);
    }

    @Override
    @NotNull
    public <T> WebSingleIndexedResult<T, WebTable> extractFooter(@NotNull WebTableValueExtractor<T> extractor) {
        return WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, extractor.fromFooter()).singleResult();
    }

    @Override
    @NotNull
    public WebTable getElement() {
        return this.element;
    }

    @Override
    @NotNull
    public FilterResult getFilterResult() {
        this.executeFilter(this.element, this.filterBuilder);
        return this.filterResult;
    }

    @Override
    public WebTableFilter should(@NotNull WebMultipleIndexedResultMatcher<Integer> matcher) {
        WebTableMultipleIndexedResult<Integer> indexedResult = WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, Web.rowIndex());
        matcher.check(indexedResult);
        return this;
    }

    @Override
    public WebTableFilter setInitialHash(@Nullable String initialHash) {
        this.initialHash = initialHash;
        return this;
    }

    private void executeFilter(WebTable element, WebTableFilterBuilder filterBuilder) {
        Deque<WebTableFilterBuilder.WebTableRowFilterResultGroupingHolder> conditions = filterBuilder.getConditions();
        HashSet indexes = new HashSet();
        String calculatedHash = this.initialHash;
        for (WebTableFilterBuilder.WebTableRowFilterResultGroupingHolder conditionHolder : conditions) {
            WebTableRowCondition condition = conditionHolder.getCondition();
            FilterResult conditionResult = this.processConditions(element, condition, calculatedHash);
            calculatedHash = conditionResult.getHash();
            if (FilterResultGrouping.ADD == conditionHolder.getUsage()) {
                indexes.addAll(conditionResult.getIndexes());
            }
            if (FilterResultGrouping.SUBTRACT != conditionHolder.getUsage()) continue;
            indexes.removeAll(conditionResult.getIndexes());
        }
        this.filterResult = FilterResult.of(indexes, (String)calculatedHash);
    }

    private FilterResult processConditions(WebTable element, WebTableRowCondition condition, String hash) {
        FilterResult conditionResult = condition.process(element, hash);
        Deque<WebTableRowCondition.WebTableRowConditionHolder> childConditions = condition.getChildConditions();
        if (childConditions.isEmpty()) {
            return conditionResult;
        }
        String calculatedHash = conditionResult.getHash();
        HashSet<Integer> indexes = conditionResult.getIndexes();
        for (WebTableRowCondition.WebTableRowConditionHolder childConditionHolder : childConditions) {
            WebTableRowCondition childCondition = childConditionHolder.getCondition();
            FilterResult childConditionResult = this.processConditions(element, childCondition, calculatedHash);
            calculatedHash = childConditionResult.getHash();
            if (ConditionGrouping.AND == childConditionHolder.getUsage()) {
                HashSet<Integer> overallIndexes = new HashSet<Integer>();
                Iterator iterator = childConditionResult.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int childConditionIndex = (Integer)iterator.next();
                    if (!indexes.contains(childConditionIndex)) continue;
                    overallIndexes.add(childConditionIndex);
                }
                indexes = overallIndexes;
            }
            if (ConditionGrouping.OR != childConditionHolder.getUsage()) continue;
            indexes.addAll(childConditionResult.getIndexes());
        }
        return FilterResult.of((Set)indexes, (String)calculatedHash);
    }
}

