/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.radio.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebRadioButton;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.radio.condition.WebRadioButtonCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetLabelOperationType;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRadioButtonLabelStringValueCondition
implements WebRadioButtonCondition {
    private final Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> childConditions = new ArrayDeque<WebRadioButtonCondition.WebRadioButtonConditionHolder>();
    private final StringValue expectedStringValue;
    private boolean inverse = false;

    public WebRadioButtonLabelStringValueCondition(@NotNull StringValue expectedStringValue) {
        this.expectedStringValue = expectedStringValue;
    }

    public WebRadioButtonLabelStringValueCondition containsLabel() {
        return this;
    }

    public WebRadioButtonLabelStringValueCondition notContainLabel() {
        return this.inverse();
    }

    @Override
    public WebRadioButtonCondition and(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebRadioButtonCondition or(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebRadioGroup element, @Nullable String hash) {
        WebRadioButton webRadioButton = element.getWebRadioGroupFrame().getMappedBlockFrame().radioButton();
        WebLocatorChain radioGroupLocatorChain = element.getLocatorChain();
        WebLocatorHolder radioGroupLocatorHolder = radioGroupLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        radioGroupLocatorChain.addLastLocator(element.getRequiredLocator("RADIO"));
        WebGetLabelOperationType operationType = WebGetLabelOperationType.of(webRadioButton);
        WebElementOperation<String> operation = WebElementOperationHandler.of(webRadioButton, operationType, "LABEL").getOperation();
        operation.getLocatorChain().addFirstLocators(radioGroupLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(radioGroupLocatorHolder.getLocatorId());
        Map<Integer, String> labelValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(labelValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedStringValue.check(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebRadioButtonLabelStringValueCondition inverse() {
        this.inverse = true;
        return this;
    }
}

