/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.radio.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.radio.condition.WebRadioButtonCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import io.perfeccionista.framework.value.number.NumberValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRadioButtonIndexCondition
implements WebRadioButtonCondition {
    private final Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> childConditions = new ArrayDeque<WebRadioButtonCondition.WebRadioButtonConditionHolder>();
    private final Integer expectedIndex;
    private final NumberValue<Integer> expectedValue;
    private boolean inverse = false;

    public WebRadioButtonIndexCondition(@NotNull Integer expectedIndex) {
        this.expectedIndex = expectedIndex;
        this.expectedValue = null;
    }

    public WebRadioButtonIndexCondition(@NotNull NumberValue<Integer> expectedValue) {
        this.expectedIndex = null;
        this.expectedValue = expectedValue;
    }

    public WebRadioButtonIndexCondition withRadioButtonIndex() {
        return this;
    }

    public WebRadioButtonIndexCondition withoutRadioButtonIndex() {
        return this.inverse();
    }

    @Override
    public WebRadioButtonCondition and(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebRadioButtonCondition or(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebRadioGroup element, @Nullable String hash) {
        WebLocatorChain radioGroupLocatorChain = element.getLocatorChain();
        WebLocatorHolder radioGroupLocatorHolder = radioGroupLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        radioGroupLocatorChain.addLastLocator(element.getRequiredLocator("RADIO"));
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementOperation.of(radioGroupLocatorChain, operationType);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(radioGroupLocatorHolder.getLocatorId());
        Set<Integer> indexes = operationResult.getResults().keySet();
        Set<Integer> matches = this.getMatches(indexes);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Set<Integer> indexes) {
        HashSet<Integer> matches = new HashSet<Integer>();
        indexes.forEach(index -> {
            boolean check = this.expectedIndex != null ? this.expectedIndex.equals(index) : this.expectedValue.check(index);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)index);
            }
        });
        return matches;
    }

    private WebRadioButtonIndexCondition inverse() {
        this.inverse = true;
        return this;
    }
}

