/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.radio.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebRadioButton;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.radio.condition.WebRadioButtonCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsEnabledOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRadioButtonEnabledCondition
implements WebRadioButtonCondition {
    private final Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> childConditions = new ArrayDeque<WebRadioButtonCondition.WebRadioButtonConditionHolder>();
    private boolean inverse = false;

    public WebRadioButtonEnabledCondition enabled() {
        return this;
    }

    public WebRadioButtonEnabledCondition disabled() {
        return this.inverse();
    }

    @Override
    public WebRadioButtonCondition and(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebRadioButtonCondition or(@NotNull WebRadioButtonCondition condition) {
        this.childConditions.add(WebRadioButtonCondition.WebRadioButtonConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebRadioGroup element, @Nullable String hash) {
        WebRadioButton webRadioButton = element.getWebRadioGroupFrame().getMappedBlockFrame().radioButton();
        WebLocatorChain radioGroupLocatorChain = element.getLocatorChain();
        WebLocatorHolder radioGroupLocatorHolder = radioGroupLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        radioGroupLocatorChain.addLastLocator(element.getRequiredLocator("RADIO"));
        WebGetIsEnabledOperationType operationType = WebGetIsEnabledOperationType.of(webRadioButton);
        WebElementOperation<Boolean> operation = WebElementOperationHandler.of(webRadioButton, operationType, "ENABLED").getOperation();
        operation.getLocatorChain().addFirstLocators(radioGroupLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(radioGroupLocatorHolder.getLocatorId());
        Map<Integer, Boolean> enabledValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(enabledValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, Boolean> enabledValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        enabledValues.forEach((key, value) -> {
            if (value != null && (!this.inverse && value.booleanValue() || this.inverse && !value.booleanValue())) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebRadioButtonEnabledCondition inverse() {
        this.inverse = true;
        return this;
    }
}

