/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.radio;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.extractor.radio.WebRadioButtonValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.radio.WebRadioGroupMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.radio.WebRadioGroupFilter;
import io.perfeccionista.framework.pagefactory.filter.radio.WebRadioGroupFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.radio.condition.WebRadioButtonCondition;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRadioGroupFilterImpl
implements WebRadioGroupFilter {
    private final WebRadioGroup element;
    private final WebRadioGroupFilterBuilder filterBuilder;
    private String initialHash = null;
    private FilterResult filterResult = null;

    private WebRadioGroupFilterImpl(WebRadioGroup element, WebRadioGroupFilterBuilder filterBuilder) {
        this.element = element;
        this.filterBuilder = filterBuilder;
    }

    public static WebRadioGroupFilterImpl of(@NotNull WebRadioGroup element, @NotNull WebRadioGroupFilterBuilder filterBuilder) {
        return new WebRadioGroupFilterImpl(element, filterBuilder);
    }

    @Override
    @NotNull
    public <T> WebSingleIndexedResult<T, WebRadioGroup> extractOne(@NotNull WebRadioButtonValueExtractor<T> extractor) {
        return WebRadioGroupMultipleIndexedResult.of(this.element, this.filterBuilder, extractor).singleResult();
    }

    @Override
    @NotNull
    public <T> WebMultipleIndexedResult<T, WebRadioGroup> extractAll(@NotNull WebRadioButtonValueExtractor<T> extractor) {
        return WebRadioGroupMultipleIndexedResult.of(this.element, this.filterBuilder, extractor);
    }

    @Override
    @NotNull
    public WebRadioGroup getElement() {
        return this.element;
    }

    @Override
    @NotNull
    public FilterResult getFilterResult() {
        this.executeFilter(this.element, this.filterBuilder);
        return this.filterResult;
    }

    @Override
    public WebRadioGroupFilter should(@NotNull WebMultipleIndexedResultMatcher<Integer> matcher) {
        WebRadioGroupMultipleIndexedResult<Integer> indexedResult = WebRadioGroupMultipleIndexedResult.of(this.element, this.filterBuilder, Web.index());
        matcher.check(indexedResult);
        return this;
    }

    @Override
    public WebRadioGroupFilter setInitialHash(@Nullable String initialHash) {
        this.initialHash = initialHash;
        return this;
    }

    private void executeFilter(WebRadioGroup element, WebRadioGroupFilterBuilder filterBuilder) {
        Deque<WebRadioGroupFilterBuilder.WebRadioButtonFilterResultGroupingHolder> conditions = filterBuilder.getConditions();
        HashSet indexes = new HashSet();
        String calculatedHash = this.initialHash;
        for (WebRadioGroupFilterBuilder.WebRadioButtonFilterResultGroupingHolder conditionHolder : conditions) {
            WebRadioButtonCondition condition = conditionHolder.getCondition();
            FilterResult conditionResult = WebRadioGroupFilterImpl.processConditions(element, condition, calculatedHash);
            calculatedHash = conditionResult.getHash();
            if (FilterResultGrouping.ADD == conditionHolder.getUsage()) {
                indexes.addAll(conditionResult.getIndexes());
            }
            if (FilterResultGrouping.SUBTRACT != conditionHolder.getUsage()) continue;
            indexes.removeAll(conditionResult.getIndexes());
        }
        this.filterResult = FilterResult.of(indexes, (String)calculatedHash);
    }

    private static FilterResult processConditions(WebRadioGroup element, WebRadioButtonCondition condition, String hash) {
        FilterResult conditionResult = condition.process(element, hash);
        Deque<WebRadioButtonCondition.WebRadioButtonConditionHolder> childConditions = condition.getChildConditions();
        if (childConditions.isEmpty()) {
            return conditionResult;
        }
        String calculatedHash = conditionResult.getHash();
        HashSet<Integer> indexes = conditionResult.getIndexes();
        for (WebRadioButtonCondition.WebRadioButtonConditionHolder childConditionHolder : childConditions) {
            WebRadioButtonCondition childCondition = childConditionHolder.getCondition();
            FilterResult childConditionResult = WebRadioGroupFilterImpl.processConditions(element, childCondition, calculatedHash);
            calculatedHash = childConditionResult.getHash();
            if (ConditionGrouping.AND == childConditionHolder.getUsage()) {
                HashSet<Integer> overallIndexes = new HashSet<Integer>();
                Iterator iterator = childConditionResult.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int childConditionIndex = (Integer)iterator.next();
                    if (!indexes.contains(childConditionIndex)) continue;
                    overallIndexes.add(childConditionIndex);
                }
                indexes = overallIndexes;
            }
            if (ConditionGrouping.OR != childConditionHolder.getUsage()) continue;
            indexes.addAll(childConditionResult.getIndexes());
        }
        return FilterResult.of((Set)indexes, (String)calculatedHash);
    }
}

