/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetStringAttributeValueOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListBlockElementPropertyTextCondition<T extends WebBlock>
implements WebListBlockCondition<T> {
    private final Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> childConditions = new ArrayDeque<WebListBlockCondition.WebListBlockConditionHolder<T>>();
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final String propertyName;
    private final String expectedText;
    private boolean inverse = false;

    public WebListBlockElementPropertyTextCondition(@NotNull String elementPath, @NotNull String propertyName, @NotNull String expectedText) {
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.propertyName = propertyName;
        this.expectedText = expectedText;
    }

    public WebListBlockElementPropertyTextCondition(@NotNull WebChildElement elementFrame, @NotNull String propertyName, @NotNull String expectedText) {
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.propertyName = propertyName;
        this.expectedText = expectedText;
    }

    public WebListBlockElementPropertyTextCondition<T> containsProperty() {
        return this;
    }

    public WebListBlockElementPropertyTextCondition<T> notContainProperty() {
        return this.inverse();
    }

    @Override
    public WebListBlockCondition<T> and(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebListBlockCondition<T> or(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebList<T> element, @Nullable String hash) {
        WebElementOperation<String> operation;
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebChildElement elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), this.elementFrame.getElementIdentifier().getElementType());
        Optional optionalPropertyHolder = elementToFilter.getProperty(this.propertyName);
        if (optionalPropertyHolder.isPresent()) {
            WebElementPropertyHolder propertyHolder = (WebElementPropertyHolder)optionalPropertyHolder.get();
            operation = propertyHolder.getOperation(elementToFilter);
        } else {
            WebGetStringAttributeValueOperationType operationType = WebGetStringAttributeValueOperationType.of(elementToFilter, this.propertyName);
            operation = WebElementOperationHandler.of(elementToFilter, operationType, this.propertyName).getOperation();
        }
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Map<Integer, String> textValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(textValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedText.equals(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebListBlockElementPropertyTextCondition<T> inverse() {
        this.inverse = true;
        return this;
    }
}

