/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetLabelAvailable;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetLabelOperationType;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListBlockElementLabelStringValueCondition<T extends WebBlock>
implements WebListBlockCondition<T> {
    private final Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> childConditions = new ArrayDeque<WebListBlockCondition.WebListBlockConditionHolder<T>>();
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final StringValue expectedStringValue;
    private boolean inverse = false;

    public WebListBlockElementLabelStringValueCondition(@NotNull String elementPath, @NotNull StringValue expectedStringValue) {
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.expectedStringValue = expectedStringValue;
    }

    public WebListBlockElementLabelStringValueCondition(@NotNull WebGetLabelAvailable elementFrame, @NotNull StringValue expectedStringValue) {
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.expectedStringValue = expectedStringValue;
    }

    public WebListBlockElementLabelStringValueCondition<T> containsLabel() {
        return this;
    }

    public WebListBlockElementLabelStringValueCondition<T> notContainLabel() {
        return this.inverse();
    }

    @Override
    public WebListBlockCondition<T> and(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebListBlockCondition<T> or(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebList<T> element, @Nullable String hash) {
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebGetLabelAvailable elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebGetLabelAvailable.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebGetLabelAvailable.class);
        WebGetLabelOperationType operationType = WebGetLabelOperationType.of(elementToFilter);
        WebElementOperation<String> operation = WebElementOperationHandler.of(elementToFilter, operationType, "LABEL").getOperation();
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Map<Integer, String> textValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(textValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, String> textValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        textValues.forEach((key, value) -> {
            boolean check = this.expectedStringValue.check(value);
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebListBlockElementLabelStringValueCondition<T> inverse() {
        this.inverse = true;
        return this;
    }
}

