/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list.condition;

import io.perfeccionista.framework.exceptions.ElementStateNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListBlockElementHaveStateCondition<T extends WebBlock>
implements WebListBlockCondition<T> {
    private final Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> childConditions = new ArrayDeque<WebListBlockCondition.WebListBlockConditionHolder<T>>();
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final String stateName;
    private boolean inverse = false;

    public WebListBlockElementHaveStateCondition(@NotNull String elementPath, @NotNull String stateName) {
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.stateName = stateName;
    }

    public WebListBlockElementHaveStateCondition(@NotNull WebChildElement elementFrame, @NotNull String stateName) {
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.stateName = stateName;
    }

    public WebListBlockElementHaveStateCondition<T> haveState() {
        return this;
    }

    public WebListBlockElementHaveStateCondition<T> notHaveState() {
        return this.inverse();
    }

    @Override
    public WebListBlockCondition<T> and(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebListBlockCondition<T> or(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebList<T> element, @Nullable String hash) {
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebChildElement elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), this.elementFrame.getElementIdentifier().getElementType());
        Optional optionalStateHolder = elementToFilter.getState(this.stateName);
        if (!optionalStateHolder.isPresent()) {
            throw ElementStateNotFound.exception((String)PageFactoryApiMessages.ELEMENT_STATE_NOT_FOUND.getMessage(new Object[]{this.stateName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        }
        WebElementOperation<Boolean> operation = ((WebElementStateHolder)optionalStateHolder.get()).getOperation(elementToFilter).withPageSource();
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            throw exceptionMapper.mapElementException(element, (RuntimeException)originalException);
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Map<Integer, Boolean> hasStateValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(hasStateValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, Boolean> haveStateValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        haveStateValues.forEach((key, value) -> {
            boolean check = value;
            if (check && !this.inverse || !check && this.inverse) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebListBlockElementHaveStateCondition<T> inverse() {
        this.inverse = true;
        return this;
    }
}

