/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list.condition;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsEnabledAvailable;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsEnabledOperationType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListBlockElementEnabledCondition<T extends WebBlock>
implements WebListBlockCondition<T> {
    private final Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> childConditions = new ArrayDeque<WebListBlockCondition.WebListBlockConditionHolder<T>>();
    private final String elementPath;
    private final WebChildElement elementFrame;
    private boolean inverse = false;

    public WebListBlockElementEnabledCondition(@NotNull String elementPath) {
        this.elementPath = elementPath;
        this.elementFrame = null;
    }

    public WebListBlockElementEnabledCondition(@NotNull WebIsEnabledAvailable elementFrame) {
        this.elementPath = null;
        this.elementFrame = elementFrame;
    }

    public WebListBlockElementEnabledCondition<T> enabled() {
        return this;
    }

    public WebListBlockElementEnabledCondition<T> disabled() {
        return this.inverse();
    }

    @Override
    public WebListBlockCondition<T> and(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.AND, condition));
        return this;
    }

    @Override
    public WebListBlockCondition<T> or(@NotNull WebListBlockCondition<T> condition) {
        this.childConditions.add(WebListBlockCondition.WebListBlockConditionHolder.of(ConditionGrouping.OR, condition));
        return this;
    }

    @Override
    public Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> getChildConditions() {
        return this.childConditions;
    }

    @Override
    @NotNull
    public FilterResult process(@NotNull WebList<T> element, @Nullable String hash) {
        WebLocatorChain listLocatorChain = element.getLocatorChain();
        WebLocatorHolder listLocatorHolder = listLocatorChain.getLastLocator().setCalculateHash(true).setExpectedHash(hash);
        listLocatorChain.addLastLocator(element.getRequiredLocator("LI"));
        WebIsEnabledAvailable elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebIsEnabledAvailable.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebIsEnabledAvailable.class);
        WebGetIsEnabledOperationType operationType = WebGetIsEnabledOperationType.of(elementToFilter);
        WebElementOperation<Boolean> operation = WebElementOperationHandler.of(elementToFilter, operationType, "ENABLED").getOperation();
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        String calculatedHash = operationResult.getRequiredHash(listLocatorHolder.getLocatorId());
        Map<Integer, Boolean> enabledValues = operationResult.getResults();
        Set<Integer> matches = this.getMatches(enabledValues);
        return FilterResult.of(matches, (String)calculatedHash);
    }

    private Set<Integer> getMatches(Map<Integer, Boolean> enabledValues) {
        HashSet<Integer> matches = new HashSet<Integer>();
        enabledValues.forEach((key, value) -> {
            if (value != null && (!this.inverse && value.booleanValue() || this.inverse && !value.booleanValue())) {
                matches.add((Integer)key);
            }
        });
        return matches;
    }

    private WebListBlockElementEnabledCondition<T> inverse() {
        this.inverse = true;
        return this;
    }
}

