/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.ConditionGrouping;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListFilterImpl<T extends WebBlock>
implements WebListFilter<T> {
    private final WebList<T> element;
    private final WebListFilterBuilder<T> filterBuilder;
    private String initialHash = null;
    private FilterResult filterResult = null;

    private WebListFilterImpl(WebList<T> element, WebListFilterBuilder<T> filterBuilder) {
        this.element = element;
        this.filterBuilder = filterBuilder;
    }

    public static <T extends WebBlock> WebListFilterImpl<T> of(@NotNull WebList<T> element, @NotNull WebListFilterBuilder<T> filterBuilder) {
        return new WebListFilterImpl<T>(element, filterBuilder);
    }

    @Override
    @NotNull
    public <R> WebMultipleIndexedResult<R, WebList<T>> extractAll(@NotNull WebListBlockValueExtractor<R, T> extractor) {
        return WebListMultipleIndexedResult.of(this.element, this.filterBuilder, extractor);
    }

    @Override
    @NotNull
    public <R> WebSingleIndexedResult<R, WebList<T>> extractOne(@NotNull WebListBlockValueExtractor<R, T> extractor) {
        return WebListMultipleIndexedResult.of(this.element, this.filterBuilder, extractor).singleResult();
    }

    @Override
    public WebListFilter<T> forSingleBlock(@NotNull Consumer<T> listBlockConsumer) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.assertInvocation((String)"", (Object[])new Object[0]), () -> {
            WebBlock singleBlock = (WebBlock)WebListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.block(this.element.getWebListFrame().getMappedBlockClass())).singleResult().getNotNullResult();
            listBlockConsumer.accept(singleBlock);
        });
        return this;
    }

    @Override
    public WebListFilter<T> forEachBlock(@NotNull Consumer<T> listBlockConsumer) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.assertInvocation((String)"", (Object[])new Object[0]), () -> WebListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.block(this.element.getWebListFrame().getMappedBlockClass())).getResults().forEach((key, value) -> listBlockConsumer.accept(value)));
        return this;
    }

    @Override
    public WebListFilter<T> forFirstBlock(@NotNull Consumer<T> listBlockConsumer) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.assertInvocation((String)"", (Object[])new Object[0]), () -> {
            WebBlock firstBlock = (WebBlock)WebListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.block(this.element.getWebListFrame().getMappedBlockClass())).getResults().entrySet().stream().min(Map.Entry.comparingByKey()).orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element))).getValue();
            listBlockConsumer.accept(firstBlock);
        });
        return this;
    }

    @Override
    public WebListFilter<T> forLastBlock(@NotNull Consumer<T> listBlockConsumer) {
        CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.assertInvocation((String)"", (Object[])new Object[0]), () -> {
            WebBlock firstBlock = (WebBlock)WebListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.block(this.element.getWebListFrame().getMappedBlockClass())).getResults().entrySet().stream().max(Map.Entry.comparingByKey()).orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element))).getValue();
            listBlockConsumer.accept(firstBlock);
        });
        return this;
    }

    @Override
    @NotNull
    public WebList<T> getElement() {
        return this.element;
    }

    @Override
    @NotNull
    public FilterResult getFilterResult() {
        this.executeFilter(this.element, this.filterBuilder);
        return this.filterResult;
    }

    @Override
    public WebListFilter<T> should(@NotNull WebMultipleIndexedResultMatcher<Integer> matcher) {
        WebListMultipleIndexedResult indexedResult = WebListMultipleIndexedResult.of(this.element, this.filterBuilder, Web.blockIndex());
        matcher.check(indexedResult);
        return this;
    }

    @Override
    public WebListFilter<T> setInitialHash(@Nullable String initialHash) {
        this.initialHash = initialHash;
        return this;
    }

    private void executeFilter(WebList<T> element, WebListFilterBuilder<T> filterBuilder) {
        Deque<WebListFilterBuilder.WebListBlockFilterResultGroupingHolder<T>> conditions = filterBuilder.getConditions();
        HashSet indexes = new HashSet();
        String calculatedHash = this.initialHash;
        for (WebListFilterBuilder.WebListBlockFilterResultGroupingHolder<T> conditionHolder : conditions) {
            WebListBlockCondition<T> condition = conditionHolder.getCondition();
            FilterResult conditionResult = WebListFilterImpl.processConditions(element, condition, calculatedHash);
            calculatedHash = conditionResult.getHash();
            if (FilterResultGrouping.ADD == conditionHolder.getUsage()) {
                indexes.addAll(conditionResult.getIndexes());
            }
            if (FilterResultGrouping.SUBTRACT != conditionHolder.getUsage()) continue;
            indexes.removeAll(conditionResult.getIndexes());
        }
        this.filterResult = FilterResult.of(indexes, (String)calculatedHash);
    }

    private static <T extends WebBlock> FilterResult processConditions(WebList<T> element, WebListBlockCondition<T> condition, String hash) {
        FilterResult conditionResult = condition.process(element, hash);
        Deque<WebListBlockCondition.WebListBlockConditionHolder<T>> childConditions = condition.getChildConditions();
        if (childConditions.isEmpty()) {
            return conditionResult;
        }
        String calculatedHash = conditionResult.getHash();
        HashSet<Integer> indexes = conditionResult.getIndexes();
        for (WebListBlockCondition.WebListBlockConditionHolder<T> childConditionHolder : childConditions) {
            WebListBlockCondition<T> childCondition = childConditionHolder.getCondition();
            FilterResult childConditionResult = WebListFilterImpl.processConditions(element, childCondition, calculatedHash);
            calculatedHash = childConditionResult.getHash();
            if (ConditionGrouping.AND == childConditionHolder.getUsage()) {
                HashSet<Integer> overallIndexes = new HashSet<Integer>();
                Iterator iterator = childConditionResult.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int childConditionIndex = (Integer)iterator.next();
                    if (!indexes.contains(childConditionIndex)) continue;
                    overallIndexes.add(childConditionIndex);
                }
                indexes = overallIndexes;
            }
            if (ConditionGrouping.OR != childConditionHolder.getUsage()) continue;
            indexes.addAll(childConditionResult.getIndexes());
        }
        return FilterResult.of((Set)indexes, (String)calculatedHash);
    }
}

