/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.filter.list;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.filter.FilterResultGrouping;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterBuilder;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterImpl;
import io.perfeccionista.framework.pagefactory.filter.list.condition.WebListBlockCondition;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

public class WebListFilterBuilderImpl<T extends WebBlock>
implements WebListFilterBuilder<T> {
    private final Deque<WebListFilterBuilder.WebListBlockFilterResultGroupingHolder<T>> conditions = new ArrayDeque<WebListFilterBuilder.WebListBlockFilterResultGroupingHolder<T>>();

    private WebListFilterBuilderImpl() {
    }

    public static <T extends WebBlock> WebListFilterBuilder<T> webListFilterBuilderWith(@NotNull WebListBlockCondition<T> condition) {
        return new WebListFilterBuilderImpl<T>().add(condition);
    }

    public static <T extends WebBlock> WebListFilterBuilder<T> webListFilterBuilderWithout(@NotNull WebListBlockCondition<T> condition) {
        return new WebListFilterBuilderImpl().add(Web.allBlocks()).subtract(condition);
    }

    @Override
    public WebListFilterBuilder<T> add(@NotNull WebListBlockCondition<T> condition) {
        this.conditions.addLast(WebListFilterBuilder.WebListBlockFilterResultGroupingHolder.of(FilterResultGrouping.ADD, condition));
        return this;
    }

    @Override
    public WebListFilterBuilder<T> subtract(@NotNull WebListBlockCondition<T> condition) {
        this.conditions.addLast(WebListFilterBuilder.WebListBlockFilterResultGroupingHolder.of(FilterResultGrouping.SUBTRACT, condition));
        return this;
    }

    @Override
    @NotNull
    public WebListFilter<T> build(@NotNull WebList<T> element) {
        return WebListFilterImpl.of(element, this);
    }

    @Override
    public Deque<WebListFilterBuilder.WebListBlockFilterResultGroupingHolder<T>> getConditions() {
        return this.conditions;
    }
}

