/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.LocatorProcessing;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocator;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorRegistry;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorStrategy;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import io.perfeccionista.framework.utils.JsonUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import io.perfeccionista.framework.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebLocatorAnnotationHandler {
    private WebLocatorAnnotationHandler() {
    }

    @NotNull
    public static WebLocatorRegistry createWebLocatorRegistryFor(@NotNull Class<? extends WebPage> webElementClass) {
        HashMap<String, WebLocatorHolder> webLocators = new HashMap<String, WebLocatorHolder>();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebLocator.class, WebPage.class, webElementClass).forEach(webLocator -> webLocators.put(webLocator.component(), WebLocatorAnnotationHandler.createWebLocatorHolder(webLocator)));
        return WebLocatorRegistry.of(webLocators);
    }

    @NotNull
    public static WebLocatorRegistry createWebLocatorRegistryFor(@NotNull WebChildElement webChildElement, @NotNull Method elementMethod, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebLocatorHolder> webLocators = configuration.getWebLocatorConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebLocator.class, WebChildElement.class, webChildElement.getClass()).forEach(webLocator -> webLocators.put(webLocator.component(), WebLocatorAnnotationHandler.createWebLocatorHolder(webLocator)));
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, WebLocator.class).forEach(webLocator -> webLocators.put(webLocator.component(), WebLocatorAnnotationHandler.createWebLocatorHolder(webLocator)));
        return WebLocatorRegistry.of(webLocators);
    }

    @NotNull
    public static WebLocatorRegistry createWebLocatorRegistryFor(@NotNull WebChildElement webChildElement, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebLocatorHolder> webLocators = configuration.getWebLocatorConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebLocator.class, WebChildElement.class, webChildElement.getClass()).forEach(webLocator -> webLocators.put(webLocator.component(), WebLocatorAnnotationHandler.createWebLocatorHolder(webLocator)));
        return WebLocatorRegistry.of(webLocators);
    }

    @NotNull
    public static WebLocatorHolder createWebLocatorHolder(@NotNull WebLocator webLocator) {
        Optional<WebLocatorHolder> optionalWebLocatorHolder = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webLocator);
        if (optionalWebLocatorHolder.isPresent()) {
            WebLocatorHolder webLocatorHolder = optionalWebLocatorHolder.get();
            webLocatorHolder.setSingle(webLocator.single());
            webLocatorHolder.setStrictSearch(webLocator.strictSearch());
            webLocatorHolder.setOnlyWithinParent(webLocator.onlyWithinParent());
            for (Class<? extends EndpointHandler<Void>> endpointHandlerClass : webLocator.invokeOnCall()) {
                webLocatorHolder.addInvokedOnCallFunction((EndpointHandler<Void>)((EndpointHandler)ReflectionUtilsForClasses.newInstance(endpointHandlerClass, (Object[])new Object[0])));
            }
            return webLocatorHolder;
        }
        throw LocatorProcessing.exception((String)PageFactoryApiMessages.LOCATOR_STRATEGY_VALIDATION_FAILED.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"WebLocator", (JsonNode)WebLocatorAnnotationHandler.webLocatorToJson(webLocator)));
    }

    public static Optional<WebLocatorHolder> createOptionalWebLocatorHolder(WebLocator webLocator) {
        WebLocatorHolder webLocatorHolder = null;
        if (webLocator.selfNode()) {
            webLocatorHolder = WebLocatorHolder.selfNode(webLocator.component());
        }
        if (StringUtils.isNotBlank((String)webLocator.id())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.ID, webLocator.id());
        }
        if (StringUtils.isNotBlank((String)webLocator.css())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.CSS, webLocator.css());
        }
        if (StringUtils.isNotBlank((String)webLocator.xpath())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.XPATH, webLocator.xpath());
        }
        if (StringUtils.isNotBlank((String)webLocator.className())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.CLASS_NAME, webLocator.className());
        }
        if (StringUtils.isNotBlank((String)webLocator.tagName())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.TAG_NAME, webLocator.tagName());
        }
        if (StringUtils.isNotBlank((String)webLocator.name())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.NAME, webLocator.name());
        }
        if (StringUtils.isNotBlank((String)webLocator.dti())) {
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.DTI, webLocator.dti());
        }
        if (StringUtils.isNotBlank((String)webLocator.text())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.TEXT, webLocator.text());
        }
        if (StringUtils.isNotBlank((String)webLocator.containsText())) {
            WebLocatorAnnotationHandler.checkWebLocatorStrategyIsEmpty(webLocatorHolder, webLocator);
            webLocatorHolder = WebLocatorHolder.of(webLocator.component(), WebLocatorStrategy.CONTAINS_TEXT, webLocator.containsText());
        }
        if (Objects.isNull(webLocatorHolder)) {
            return Optional.empty();
        }
        webLocatorHolder.setSingle(webLocator.single()).setStrictSearch(webLocator.strictSearch()).setOnlyWithinParent(webLocator.onlyWithinParent());
        for (Class<? extends EndpointHandler<Void>> endpointHandlerClass : webLocator.invokeOnCall()) {
            webLocatorHolder.addInvokedOnCallFunction((EndpointHandler<Void>)((EndpointHandler)ReflectionUtilsForClasses.newInstance(endpointHandlerClass, (Object[])new Object[0])));
        }
        return Optional.of(webLocatorHolder);
    }

    private static void checkWebLocatorStrategyIsEmpty(@Nullable WebLocatorHolder webLocatorHolder, WebLocator webLocator) {
        if (webLocatorHolder != null) {
            throw LocatorProcessing.exception((String)PageFactoryApiMessages.LOCATOR_STRATEGY_VALIDATION_FAILED.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"WebLocator", (JsonNode)WebLocatorAnnotationHandler.webLocatorToJson(webLocator)));
        }
    }

    private static JsonNode webLocatorToJson(WebLocator webLocator) {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("component", webLocator.component()).put("id", webLocator.id()).put("css", webLocator.css()).put("xpath", webLocator.xpath()).put("className", webLocator.className()).put("tagName", webLocator.tagName()).put("dti", webLocator.dti()).put("name", webLocator.name()).put("text", webLocator.text()).put("containsText", webLocator.containsText()).put("selfNode", webLocator.selfNode()).put("single", webLocator.single()).put("strictSearch", webLocator.strictSearch()).put("onlyWithinParent", webLocator.onlyWithinParent());
        ArrayNode invokeOnCallNode = rootNode.putArray("invokeOnCall");
        for (Class<? extends EndpointHandler<Void>> jsFunctionClass : webLocator.invokeOnCall()) {
            invokeOnCallNode.add(jsFunctionClass.getCanonicalName());
        }
        return rootNode;
    }
}

