/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementState;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateExtractor;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateRegistry;
import io.perfeccionista.framework.pagefactory.factory.handlers.WebLocatorAnnotationHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WebElementStateAnnotationHandler {
    private WebElementStateAnnotationHandler() {
    }

    @NotNull
    public static WebElementStateRegistry createWebElementStateRegistryFor(@NotNull WebChildElement webChildElement, @NotNull Method elementMethod, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebElementStateHolder> webElementStates = configuration.getWebElementStateConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementState.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementState -> webElementStates.put(webElementState.name(), WebElementStateAnnotationHandler.createWebElementStateHolder(webElementState)));
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, WebElementState.class).forEach(webElementState -> webElementStates.put(webElementState.name(), WebElementStateAnnotationHandler.createWebElementStateHolder(webElementState)));
        return WebElementStateRegistry.of(webElementStates);
    }

    @NotNull
    public static WebElementStateRegistry createWebElementStateRegistryFor(@NotNull WebChildElement webChildElement, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebElementStateHolder> webElementStates = configuration.getWebElementStateConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementState.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementState -> webElementStates.put(webElementState.name(), WebElementStateAnnotationHandler.createWebElementStateHolder(webElementState)));
        return WebElementStateRegistry.of(webElementStates);
    }

    @NotNull
    protected static WebElementStateHolder createWebElementStateHolder(@NotNull WebElementState webElementState) {
        Optional<WebLocatorHolder> optionalWebLocatorHolder = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webElementState.locator());
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(webElementState.params()));
        Constructor constructor = ReflectionUtilsForClasses.getDeclaredConstructor(webElementState.extractor());
        WebElementStateExtractor extractorInstance = (WebElementStateExtractor)ReflectionUtilsForClasses.newInstance((Constructor)constructor, (Object[])new Object[]{args});
        return WebElementStateHolder.of(webElementState.name(), optionalWebLocatorHolder.orElse(null), extractorInstance);
    }
}

