/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementProperty;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyExtractor;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyRegistry;
import io.perfeccionista.framework.pagefactory.factory.handlers.WebLocatorAnnotationHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WebElementPropertyAnnotationHandler {
    private WebElementPropertyAnnotationHandler() {
    }

    @NotNull
    public static WebElementPropertyRegistry createWebElementPropertyRegistryFor(@NotNull WebChildElement webChildElement, @NotNull Method elementMethod, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebElementPropertyHolder> webElementProperties = configuration.getWebElementPropertyConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementProperty.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementProperty -> webElementProperties.put(webElementProperty.name(), WebElementPropertyAnnotationHandler.createWebElementPropertyHolder(webElementProperty)));
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, WebElementProperty.class).forEach(webElementProperty -> webElementProperties.put(webElementProperty.name(), WebElementPropertyAnnotationHandler.createWebElementPropertyHolder(webElementProperty)));
        return WebElementPropertyRegistry.of(webElementProperties);
    }

    @NotNull
    public static WebElementPropertyRegistry createWebElementPropertyRegistryFor(@NotNull WebChildElement webChildElement, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, WebElementPropertyHolder> webElementProperties = configuration.getWebElementPropertyConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementProperty.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementProperty -> webElementProperties.put(webElementProperty.name(), WebElementPropertyAnnotationHandler.createWebElementPropertyHolder(webElementProperty)));
        return WebElementPropertyRegistry.of(webElementProperties);
    }

    @NotNull
    protected static WebElementPropertyHolder createWebElementPropertyHolder(@NotNull WebElementProperty webElementProperty) {
        Optional<WebLocatorHolder> optionalWebLocatorHolder = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webElementProperty.locator());
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(webElementProperty.params()));
        Constructor constructor = ReflectionUtilsForClasses.getDeclaredConstructor(webElementProperty.extractor());
        WebElementPropertyExtractor extractorInstance = (WebElementPropertyExtractor)ReflectionUtilsForClasses.newInstance((Constructor)constructor, (Object[])new Object[]{args});
        return WebElementPropertyHolder.of(webElementProperty.name(), optionalWebLocatorHolder.orElse(null), extractorInstance);
    }
}

