/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.actions.WebElementAction;
import io.perfeccionista.framework.pagefactory.elements.actions.base.EndpointHandlerRegistry;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WebElementActionAnnotationHandler {
    private WebElementActionAnnotationHandler() {
    }

    @NotNull
    public static EndpointHandlerRegistry createWebElementActionRegistryFor(@NotNull WebChildElement webChildElement, @NotNull Method elementMethod, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, Class<? extends EndpointHandler>> endpointHandlers = configuration.getWebElementActionConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementAction.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementAction -> endpointHandlers.put(webElementAction.name(), webElementAction.handler()));
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, WebElementAction.class).forEach(webElementAction -> endpointHandlers.put(webElementAction.name(), webElementAction.handler()));
        return EndpointHandlerRegistry.of(endpointHandlers);
    }

    @NotNull
    public static EndpointHandlerRegistry createWebElementActionRegistryFor(@NotNull WebChildElement webChildElement, @NotNull WebPageFactoryPreferences configuration) {
        Map<String, Class<? extends EndpointHandler>> endpointHandlers = configuration.getWebElementActionConfiguration(webChildElement.getClass()).asMap();
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(WebElementAction.class, WebChildElement.class, webChildElement.getClass()).forEach(webElementAction -> endpointHandlers.put(webElementAction.name(), webElementAction.handler()));
        return EndpointHandlerRegistry.of(endpointHandlers);
    }
}

