/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.DefaultWebTextBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.UseMappedWebTextTableColumn;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.pagefactory.factory.handlers.WebLocatorAnnotationHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UseMappedWebTextTableColumnAnnotationHandler {
    private UseMappedWebTextTableColumnAnnotationHandler() {
    }

    @NotNull
    public static WebTableFrame<DefaultWebTextBlock> createWebTextTableFrame(@NotNull WebTextTable webTextTable, @NotNull Method elementMethod, @NotNull WebPageFactory webPageFactory) {
        HashMap<String, WebLocatorHolder> headerLocators = new HashMap<String, WebLocatorHolder>();
        HashMap<String, WebLocatorHolder> bodyLocators = new HashMap<String, WebLocatorHolder>();
        HashMap<String, WebLocatorHolder> footerLocators = new HashMap<String, WebLocatorHolder>();
        HashMap headers = new HashMap();
        HashMap body = new HashMap();
        HashMap footers = new HashMap();
        HashSet<String> processedColumns = new HashSet<String>();
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, UseMappedWebTextTableColumn.class).forEach(webMappedTableColumn -> {
            String processedColumnName = webMappedTableColumn.name();
            if (!processedColumns.contains(processedColumnName)) {
                WebLocatorHolder headerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.headerLocator()).orElse(null);
                headerLocators.put(processedColumnName, headerLocator);
                WebLocatorHolder bodyLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.bodyLocator()).orElse(null);
                bodyLocators.put(processedColumnName, bodyLocator);
                WebLocatorHolder footerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.footerLocator()).orElse(null);
                footerLocators.put(processedColumnName, footerLocator);
                if (Objects.nonNull(headerLocator)) {
                    DefaultWebTextBlock headerColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.headerClass());
                    headers.put(processedColumnName, headerColumnBlock);
                }
                if (Objects.nonNull(bodyLocator)) {
                    DefaultWebTextBlock bodyColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.bodyClass());
                    body.put(processedColumnName, bodyColumnBlock);
                }
                if (Objects.nonNull(footerLocator)) {
                    DefaultWebTextBlock footerColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.footerClass());
                    footers.put(processedColumnName, footerColumnBlock);
                }
                processedColumns.add(processedColumnName);
            }
        });
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(UseMappedWebTextTableColumn.class, WebChildElement.class, webTextTable.getClass()).forEach(webMappedTableColumn -> {
            String processedColumnName = webMappedTableColumn.name();
            if (!processedColumns.contains(processedColumnName)) {
                WebLocatorHolder headerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.headerLocator()).orElse(null);
                headerLocators.put(processedColumnName, headerLocator);
                WebLocatorHolder bodyLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.bodyLocator()).orElse(null);
                bodyLocators.put(processedColumnName, bodyLocator);
                WebLocatorHolder footerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.footerLocator()).orElse(null);
                footerLocators.put(processedColumnName, footerLocator);
                if (Objects.nonNull(headerLocator)) {
                    DefaultWebTextBlock headerColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.headerClass());
                    headers.put(processedColumnName, headerColumnBlock);
                }
                if (Objects.nonNull(bodyLocator)) {
                    DefaultWebTextBlock bodyColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.bodyClass());
                    body.put(processedColumnName, bodyColumnBlock);
                }
                if (Objects.nonNull(footerLocator)) {
                    DefaultWebTextBlock footerColumnBlock = webPageFactory.createMappedWebBlock(webTextTable, webMappedTableColumn.footerClass());
                    footers.put(processedColumnName, footerColumnBlock);
                }
                processedColumns.add(processedColumnName);
            }
        });
        return new WebTableFrame<DefaultWebTextBlock>(webTextTable, processedColumns, headerLocators, bodyLocators, footerLocators, headers, body, footers);
    }
}

