/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.UseMappedWebTableColumn;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.pagefactory.factory.handlers.WebLocatorAnnotationHandler;
import io.perfeccionista.framework.utils.AnnotationUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UseMappedWebTableColumnAnnotationHandler {
    private UseMappedWebTableColumnAnnotationHandler() {
    }

    @NotNull
    public static WebTableFrame<WebBlock> createWebTableFrame(@NotNull WebTable webTable, @NotNull Method elementMethod, @NotNull WebPageFactory webPageFactory) {
        HashMap<String, WebLocatorHolder> headerLocators = new HashMap<String, WebLocatorHolder>();
        HashMap<String, WebLocatorHolder> bodyLocators = new HashMap<String, WebLocatorHolder>();
        HashMap<String, WebLocatorHolder> footerLocators = new HashMap<String, WebLocatorHolder>();
        HashMap headers = new HashMap();
        HashMap body = new HashMap();
        HashMap footers = new HashMap();
        HashSet<String> processedColumns = new HashSet<String>();
        AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)elementMethod, UseMappedWebTableColumn.class).forEach(webMappedTableColumn -> {
            String processedColumnName = webMappedTableColumn.name();
            if (!processedColumns.contains(processedColumnName)) {
                WebLocatorHolder headerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.headerLocator()).orElse(null);
                headerLocators.put(processedColumnName, headerLocator);
                WebLocatorHolder bodyLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.bodyLocator()).orElse(null);
                bodyLocators.put(processedColumnName, bodyLocator);
                WebLocatorHolder footerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.footerLocator()).orElse(null);
                footerLocators.put(processedColumnName, footerLocator);
                if (Objects.nonNull(headerLocator)) {
                    WebBlock headerColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.headerClass());
                    headers.put(processedColumnName, headerColumnBlock);
                }
                if (Objects.nonNull(bodyLocator)) {
                    WebBlock bodyColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.bodyClass());
                    body.put(processedColumnName, bodyColumnBlock);
                }
                if (Objects.nonNull(footerLocator)) {
                    WebBlock footerColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.footerClass());
                    footers.put(processedColumnName, footerColumnBlock);
                }
                processedColumns.add(processedColumnName);
            }
        });
        AnnotationUtils.findAllRepeatableAnnotationsInHierarchy(UseMappedWebTableColumn.class, WebChildElement.class, webTable.getClass()).forEach(webMappedTableColumn -> {
            String processedColumnName = webMappedTableColumn.name();
            if (!processedColumns.contains(processedColumnName)) {
                WebLocatorHolder headerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.headerLocator()).orElse(null);
                headerLocators.put(processedColumnName, headerLocator);
                WebLocatorHolder bodyLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.bodyLocator()).orElse(null);
                bodyLocators.put(processedColumnName, bodyLocator);
                WebLocatorHolder footerLocator = WebLocatorAnnotationHandler.createOptionalWebLocatorHolder(webMappedTableColumn.footerLocator()).orElse(null);
                footerLocators.put(processedColumnName, footerLocator);
                if (Objects.nonNull(headerLocator)) {
                    WebBlock headerColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.headerClass());
                    headers.put(processedColumnName, headerColumnBlock);
                }
                if (Objects.nonNull(bodyLocator)) {
                    WebBlock bodyColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.bodyClass());
                    body.put(processedColumnName, bodyColumnBlock);
                }
                if (Objects.nonNull(footerLocator)) {
                    WebBlock footerColumnBlock = webPageFactory.createMappedWebBlock(webTable, webMappedTableColumn.footerClass());
                    footers.put(processedColumnName, footerColumnBlock);
                }
                processedColumns.add(processedColumnName);
            }
        });
        return new WebTableFrame<WebBlock>(webTable, processedColumns, headerLocators, bodyLocators, footerLocators, headers, body, footers);
    }
}

