/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.exceptions.MappedBlockIncorrectType;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.DefaultWebRadioButtonBlock;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.mapping.UseMappedWebBlock;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebRadioGroupFrame;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.utils.AnnotationUtils;
import io.perfeccionista.framework.utils.CastUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class UseMappedWebRadioButtonBlockAnnotationHandler {
    private UseMappedWebRadioButtonBlockAnnotationHandler() {
    }

    @NotNull
    public static WebRadioGroupFrame<DefaultWebRadioButtonBlock> createWebRadioGroupFrame(@NotNull WebRadioGroup webRadioGroup, @NotNull Method elementMethod, @NotNull WebPageFactory webPageFactory, @NotNull WebPageFactoryPreferences configuration) {
        Optional optionalMethodAnnotation;
        Class<? extends WebBlock> webMappedBlockClass = configuration.getWebMappedBlock(webRadioGroup.getClass());
        Optional optionalClassAnnotation = AnnotationUtils.findFirstAnnotationInHierarchy(UseMappedWebBlock.class, WebChildElement.class, webRadioGroup.getClass());
        if (optionalClassAnnotation.isPresent()) {
            webMappedBlockClass = ((UseMappedWebBlock)optionalClassAnnotation.get()).value();
        }
        if ((optionalMethodAnnotation = AnnotationUtils.findAnnotation((AnnotatedElement)elementMethod, UseMappedWebBlock.class)).isPresent()) {
            webMappedBlockClass = ((UseMappedWebBlock)optionalMethodAnnotation.get()).value();
        }
        DefaultWebRadioButtonBlock webRadioButtonBlock = null;
        if (Objects.nonNull(webMappedBlockClass)) {
            if (!CastUtils.isSubtypeOf(webMappedBlockClass, DefaultWebRadioButtonBlock.class)) {
                throw MappedBlockIncorrectType.exception((String)PageFactoryApiMessages.MAPPED_BLOCK_IMPLEMENTATION_INCORRECT_TYPE.getMessage(new Object[]{DefaultWebRadioButtonBlock.class.getCanonicalName()}));
            }
            webRadioButtonBlock = (DefaultWebRadioButtonBlock)webPageFactory.createMappedWebBlock(webRadioGroup, webMappedBlockClass);
        }
        return new WebRadioGroupFrame<Object>(webRadioGroup, webRadioButtonBlock);
    }
}

