/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory.handlers;

import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebListFrame;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class UseMappedWebBlockAnnotationHandler {
    private UseMappedWebBlockAnnotationHandler() {
    }

    @NotNull
    public static <T extends WebBlock> WebListFrame<WebBlock> createWebListFrame(@NotNull WebList<T> webList, @NotNull Method elementMethod, @NotNull WebPageFactory webPageFactory, @NotNull WebPageFactoryPreferences configuration) {
        Class<? extends WebChildElement> webChildElementType = webList.getElementIdentifier().getElementType();
        Class<Object> webMappedBlockClass = configuration.getWebMappedBlock(webChildElementType);
        if (elementMethod.getReturnType().equals(WebList.class)) {
            Type genericReturnType = elementMethod.getGenericReturnType();
            webMappedBlockClass = genericReturnType instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)genericReturnType).getActualTypeArguments()[0] : WebBlock.class;
        } else {
            Optional optionalGenericListInterface = ReflectionUtilsForClasses.findGenericInterface(elementMethod.getReturnType(), WebList.class);
            if (optionalGenericListInterface.isPresent()) {
                Type genericListInterface = (Type)optionalGenericListInterface.get();
                webMappedBlockClass = genericListInterface instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)genericListInterface).getActualTypeArguments()[0] : WebBlock.class;
            }
        }
        WebBlock webListBlock = null;
        if (Objects.nonNull(webMappedBlockClass)) {
            webListBlock = webPageFactory.createMappedWebBlock(webList, webMappedBlockClass);
        }
        return new WebListFrame<WebBlock>(webList, webListBlock);
    }
}

