/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory;

import io.perfeccionista.framework.exceptions.ElementNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.DefaultWebRadioButtonBlock;
import io.perfeccionista.framework.pagefactory.elements.DefaultWebTextBlock;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.WebRadioButton;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.WebTableRow;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.base.TableSection;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentHolderForChildElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentHolderForIsolatedStructuralElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentHolderForStructuralElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.elements.registry.WebElementRegistry;
import io.perfeccionista.framework.pagefactory.factory.WebElementDecorator;
import io.perfeccionista.framework.pagefactory.factory.WebElementInitializer;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.utils.WebElementUtils;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class WebPageFactory {
    public static final String RADIO_BUTTON_METHOD_NAME = "radioButton";
    protected final WebPageFactoryPreferences configuration;
    protected final WebElementInitializer initializer;
    protected final WebElementDecorator decorator;

    public WebPageFactory(@NotNull WebPageFactoryPreferences configuration) {
        this.configuration = configuration;
        this.initializer = new WebElementInitializer(configuration);
        this.decorator = new WebElementDecorator(configuration, this);
    }

    @NotNull
    public WebPage createWebPage(@NotNull Class<? extends WebPage> webPageClass) {
        WebPage webPageInstance = this.initializer.initWebPageInstance(webPageClass);
        List<Method> webChildElementMethods = WebElementUtils.getWebChildElementMethods(webPageClass);
        WebElementRegistry webPageElementRegistry = this.createWebChildElementRegistry(webPageInstance, webChildElementMethods);
        return this.decorator.decorateWebPageInstance(webPageInstance, webPageElementRegistry);
    }

    public WebChildElement createWebChildElement(@NotNull WebParentElement parent, @NotNull Method webChildElementMethod) {
        Class<?> childElementType = webChildElementMethod.getReturnType();
        WebChildElement childElementInstance = this.initializer.initWebChildElement(childElementType);
        return this.decorator.decorateWebChildElementInstance(childElementInstance, WebParentHolderForChildElement.of(parent), webChildElementMethod);
    }

    public WebBlock createWebBlock(@NotNull WebParentElement parent, @NotNull Method webBlockMethod) {
        Class<?> webBlockClass = webBlockMethod.getReturnType();
        Object webBlockInstance = this.initializer.initWebBlock(webBlockClass);
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(webBlockClass);
        WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)webBlockInstance, childElementMethods);
        return this.decorator.decorateWebBlockInstance((WebBlock)webBlockInstance, elementRegistry, WebParentHolderForChildElement.of(parent), webBlockMethod);
    }

    public <T extends WebBlock> T createMappedWebBlock(@NotNull WebChildElement parent, @NotNull Class<T> webMappedBlockClass) {
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(webMappedBlockClass);
        T webMappedBlockInstance = this.initializer.initMappedWebBlock(webMappedBlockClass);
        WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)webMappedBlockInstance, childElementMethods);
        WebParentHolderForIsolatedStructuralElement parentInfo = WebParentHolderForIsolatedStructuralElement.of(parent);
        return this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, webMappedBlockClass, elementRegistry, parentInfo);
    }

    public Map<Integer, WebRadioButton> createWebRadioButtons(@NotNull WebRadioGroup webRadioGroup, @NotNull FilterResult filterResult) {
        HashMap<Integer, WebRadioButton> webRadioButtons = new HashMap<Integer, WebRadioButton>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        WebLocatorHolder radioButtonLocatorHolder = webRadioGroup.getRequiredLocator("RADIO");
        Class<? extends WebChildElement> mappedBlockClass = webRadioGroup.getWebRadioGroupFrame().getMappedBlockFrame().getElementIdentifier().getElementType();
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(mappedBlockClass);
        Method webRadioButtonMethod = childElementMethods.stream().filter(method -> RADIO_BUTTON_METHOD_NAME.equals(method.getName())).filter(method -> method.getParameterCount() == 0).filter(method -> WebRadioButton.class.isAssignableFrom(method.getReturnType())).findFirst().orElseThrow(() -> ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{RADIO_BUTTON_METHOD_NAME})));
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            DefaultWebRadioButtonBlock webMappedBlockInstance = (DefaultWebRadioButtonBlock)this.initializer.initMappedWebBlock(mappedBlockClass);
            WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, childElementMethods);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            WebLocatorHolder radioButtonBlockRootLocator = radioButtonLocatorHolder.clone().setSingle(true).setIndex(index);
            parentLocators.add(radioButtonBlockRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webRadioGroup, hash, parentLocators);
            WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, mappedBlockClass, elementRegistry, parentInfo);
            WebRadioButton webRadioButton = decoratedWebMappedBlockInstance.getElementRegistry().getRequiredElementByMethod(webRadioButtonMethod, WebRadioButton.class);
            webRadioButtons.put(index, webRadioButton);
        }
        return webRadioButtons;
    }

    public Map<Integer, WebBlock> createWebListBlocks(@NotNull WebList webList, @NotNull FilterResult filterResult) {
        HashMap<Integer, WebBlock> webMappedBlocks = new HashMap<Integer, WebBlock>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        WebLocatorHolder liLocatorHolder = webList.getRequiredLocator("LI");
        Class<? extends WebChildElement> mappedBlockClass = webList.getWebListFrame().getMappedBlockFrame().getElementIdentifier().getElementType();
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(mappedBlockClass);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            WebChildElement webMappedBlockInstance = this.initializer.initMappedWebBlock(mappedBlockClass);
            WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)((Object)webMappedBlockInstance), childElementMethods);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            WebLocatorHolder blockRootLocator = liLocatorHolder.clone().setSingle(true).setIndex(index);
            parentLocators.add(blockRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webList, hash, parentLocators);
            WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, mappedBlockClass, elementRegistry, parentInfo);
            webMappedBlocks.put(index, (WebBlock)decoratedWebMappedBlockInstance);
        }
        return webMappedBlocks;
    }

    public Map<Integer, DefaultWebTextBlock> createWebTextListBlocks(@NotNull WebTextList webList, @NotNull FilterResult filterResult) {
        HashMap<Integer, DefaultWebTextBlock> webMappedBlocks = new HashMap<Integer, DefaultWebTextBlock>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        WebLocatorHolder liLocatorHolder = webList.getRequiredLocator("LI");
        Class<? extends WebChildElement> mappedBlockClass = webList.getWebTextListFrame().getMappedBlockFrame().getElementIdentifier().getElementType();
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(mappedBlockClass);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            DefaultWebTextBlock webMappedBlockInstance = (DefaultWebTextBlock)this.initializer.initMappedWebBlock(mappedBlockClass);
            WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, childElementMethods);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            WebLocatorHolder textBlockRootLocator = liLocatorHolder.clone().setSingle(true).setIndex(index);
            parentLocators.add(textBlockRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webList, hash, parentLocators);
            DefaultWebTextBlock decoratedWebMappedBlockInstance = (DefaultWebTextBlock)this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, mappedBlockClass, elementRegistry, parentInfo);
            webMappedBlocks.put(index, decoratedWebMappedBlockInstance);
        }
        return webMappedBlocks;
    }

    public Map<Integer, WebBlock> createWebTableCells(@NotNull WebTable webTable, @NotNull String columnName, @NotNull TableSection tableSection, @NotNull FilterResult filterResult) {
        HashMap<Integer, WebBlock> webMappedCells = new HashMap<Integer, WebBlock>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        WebLocatorHolder tableRowLocator = webTable.getRequiredLocator("TBODY");
        WebLocatorHolder tableCellLocator = webTable.getWebTableFrame().getRequiredBodyLocator(columnName);
        Class<? extends WebChildElement> tableCellMappedBlockClass = webTable.getWebTableFrame().getRequiredBodyMappedBlock(columnName).getElementIdentifier().getElementType();
        if (TableSection.HEADER == tableSection) {
            tableRowLocator = webTable.getRequiredLocator("THEAD");
            tableCellLocator = webTable.getWebTableFrame().getRequiredHeaderLocator(columnName);
            tableCellMappedBlockClass = webTable.getWebTableFrame().getRequiredHeaderMappedBlock(columnName).getElementIdentifier().getElementType();
        }
        if (TableSection.FOOTER == tableSection) {
            tableRowLocator = webTable.getRequiredLocator("THEAD");
            tableCellLocator = webTable.getWebTableFrame().getRequiredFooterLocator(columnName);
            tableCellMappedBlockClass = webTable.getWebTableFrame().getRequiredFooterMappedBlock(columnName).getElementIdentifier().getElementType();
        }
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(tableCellMappedBlockClass);
        if (TableSection.BODY == tableSection) {
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                WebChildElement webMappedBlockInstance = this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)((Object)webMappedBlockInstance), childElementMethods);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                parentLocators.add(tableRowLocator.clone().setSingle(true).setIndex(index));
                WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                parentLocators.add(tableCellRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTable, hash, parentLocators);
                WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                webMappedCells.put(index, (WebBlock)decoratedWebMappedBlockInstance);
            }
        } else {
            WebChildElement webMappedBlockInstance = this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
            WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)((Object)webMappedBlockInstance), childElementMethods);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            parentLocators.add(tableRowLocator.clone());
            WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
            parentLocators.add(tableCellRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTable, hash, parentLocators);
            WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
            webMappedCells.put(-1, (WebBlock)decoratedWebMappedBlockInstance);
        }
        return webMappedCells;
    }

    public Map<Integer, DefaultWebTextBlock> createWebTextTableCells(@NotNull WebTextTable webTextTable, @NotNull String columnName, @NotNull TableSection tableSection, @NotNull FilterResult filterResult) {
        HashMap<Integer, DefaultWebTextBlock> webMappedCells = new HashMap<Integer, DefaultWebTextBlock>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        WebLocatorHolder tableRowLocator = webTextTable.getRequiredLocator("TBODY");
        WebLocatorHolder tableCellLocator = webTextTable.getWebTextTableFrame().getRequiredBodyLocator(columnName);
        Class<? extends WebChildElement> tableCellMappedBlockClass = webTextTable.getWebTextTableFrame().getRequiredBodyMappedBlock(columnName).getElementIdentifier().getElementType();
        if (TableSection.HEADER == tableSection) {
            tableRowLocator = webTextTable.getRequiredLocator("THEAD");
            tableCellLocator = webTextTable.getWebTextTableFrame().getRequiredHeaderLocator(columnName);
            tableCellMappedBlockClass = webTextTable.getWebTextTableFrame().getRequiredHeaderMappedBlock(columnName).getElementIdentifier().getElementType();
        }
        if (TableSection.FOOTER == tableSection) {
            tableRowLocator = webTextTable.getRequiredLocator("THEAD");
            tableCellLocator = webTextTable.getWebTextTableFrame().getRequiredFooterLocator(columnName);
            tableCellMappedBlockClass = webTextTable.getWebTextTableFrame().getRequiredFooterMappedBlock(columnName).getElementIdentifier().getElementType();
        }
        List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(tableCellMappedBlockClass);
        if (TableSection.BODY == tableSection) {
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                DefaultWebTextBlock webMappedBlockInstance = (DefaultWebTextBlock)this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, childElementMethods);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                parentLocators.add(tableRowLocator.clone().setSingle(true).setIndex(index));
                WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                parentLocators.add(tableCellRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTextTable, hash, parentLocators);
                DefaultWebTextBlock decoratedWebMappedBlockInstance = (DefaultWebTextBlock)this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                webMappedCells.put(index, decoratedWebMappedBlockInstance);
            }
        } else {
            DefaultWebTextBlock webMappedBlockInstance = (DefaultWebTextBlock)this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
            WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, childElementMethods);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            parentLocators.add(tableRowLocator.clone());
            WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
            parentLocators.add(tableCellRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTextTable, hash, parentLocators);
            DefaultWebTextBlock decoratedWebMappedBlockInstance = (DefaultWebTextBlock)this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
            webMappedCells.put(-1, decoratedWebMappedBlockInstance);
        }
        return webMappedCells;
    }

    public Map<Integer, WebTableRow> createWebTableRows(@NotNull WebTable webTable, @NotNull TableSection tableSection, @NotNull FilterResult filterResult) {
        HashMap<Integer, WebTableRow> webMappedRows = new HashMap<Integer, WebTableRow>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        Set<String> tableColumnNames = webTable.getWebTableFrame().getTableColumnNames();
        WebLocatorHolder tableRowLocator = webTable.getRequiredLocator("TBODY");
        Map<String, WebBlock> tableCellFrames = webTable.getWebTableFrame().getBody();
        Map<String, WebLocatorHolder> tableCellLocators = webTable.getWebTableFrame().getBodyLocators();
        if (TableSection.HEADER == tableSection) {
            tableRowLocator = webTable.getRequiredLocator("THEAD");
            tableCellFrames = webTable.getWebTableFrame().getHeaders();
            tableCellLocators = webTable.getWebTableFrame().getHeaderLocators();
        }
        if (TableSection.FOOTER == tableSection) {
            tableRowLocator = webTable.getRequiredLocator("THEAD");
            tableCellFrames = webTable.getWebTableFrame().getFooters();
            tableCellLocators = webTable.getWebTableFrame().getFooterLocators();
        }
        HashMap<String, List<Method>> webChildElementMethods = new HashMap<String, List<Method>>();
        for (String tableColumnName : tableColumnNames) {
            Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
            List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(tableCellMappedBlockClass);
            webChildElementMethods.put(tableColumnName, childElementMethods);
        }
        if (TableSection.BODY == tableSection) {
            Iterator<String> iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)((Object)iterator.next());
                WebTableRow webMappedRowInstance = this.initializer.initWebTableRow();
                HashMap<String, WebBlock> tableCells = new HashMap<String, WebBlock>();
                for (String tableColumnName : tableColumnNames) {
                    Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
                    WebLocatorHolder tableCellLocator = tableCellLocators.get(tableColumnName);
                    WebChildElement webMappedBlockInstance = this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                    List methods = (List)webChildElementMethods.get(tableColumnName);
                    WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)((Object)webMappedBlockInstance), methods);
                    ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                    WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                    parentLocators.add(tableCellRootLocator);
                    WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webMappedRowInstance, parentLocators);
                    WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                    tableCells.put(tableColumnName, (WebBlock)decoratedWebMappedBlockInstance);
                }
                WebElementRegistry elementRegistry = WebElementRegistry.of(tableCells);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                WebLocatorHolder tableRowRootLocator = tableRowLocator.clone().setSingle(true).setIndex(index);
                parentLocators.add(tableRowRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTable, hash, parentLocators);
                WebTableRow decoratedWebMappedRowInstance = this.decorator.decorateMappedWebBlockInstance(webMappedRowInstance, WebTableRow.class, elementRegistry, parentInfo);
                webMappedRows.put(index, decoratedWebMappedRowInstance);
            }
        } else {
            WebTableRow webMappedRowInstance = this.initializer.initWebTableRow();
            HashMap<String, WebBlock> tableCells = new HashMap<String, WebBlock>();
            for (String tableColumnName : tableColumnNames) {
                Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
                WebLocatorHolder tableCellLocator = tableCellLocators.get(tableColumnName);
                WebChildElement webMappedBlockInstance = this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                List methods = (List)webChildElementMethods.get(tableColumnName);
                WebElementRegistry elementRegistry = this.createWebChildElementRegistry((WebParentElement)((Object)webMappedBlockInstance), methods);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                parentLocators.add(tableCellRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webMappedRowInstance, parentLocators);
                WebChildElement decoratedWebMappedBlockInstance = this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                tableCells.put(tableColumnName, (WebBlock)decoratedWebMappedBlockInstance);
            }
            WebElementRegistry elementRegistry = WebElementRegistry.of(tableCells);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            WebLocatorHolder tableRowRootLocator = tableRowLocator.clone();
            parentLocators.add(tableRowRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTable, hash, parentLocators);
            WebTableRow decoratedWebMappedRowInstance = this.decorator.decorateMappedWebBlockInstance(webMappedRowInstance, WebTableRow.class, elementRegistry, parentInfo);
            webMappedRows.put(-1, decoratedWebMappedRowInstance);
        }
        return webMappedRows;
    }

    public Map<Integer, WebBlock> createWebTextTableRows(@NotNull WebTextTable webTextTable, @NotNull TableSection tableSection, @NotNull FilterResult filterResult) {
        HashMap<Integer, WebBlock> webMappedRows = new HashMap<Integer, WebBlock>();
        String hash = filterResult.getHash();
        Set indexes = filterResult.getIndexes();
        Set<String> tableColumnNames = webTextTable.getWebTextTableFrame().getTableColumnNames();
        WebLocatorHolder tableRowLocator = webTextTable.getRequiredLocator("TBODY");
        Map<String, DefaultWebTextBlock> tableCellFrames = webTextTable.getWebTextTableFrame().getBody();
        Map<String, WebLocatorHolder> tableCellLocators = webTextTable.getWebTextTableFrame().getBodyLocators();
        if (TableSection.HEADER == tableSection) {
            tableRowLocator = webTextTable.getRequiredLocator("THEAD");
            tableCellFrames = webTextTable.getWebTextTableFrame().getHeaders();
            tableCellLocators = webTextTable.getWebTextTableFrame().getHeaderLocators();
        }
        if (TableSection.FOOTER == tableSection) {
            tableRowLocator = webTextTable.getRequiredLocator("THEAD");
            tableCellFrames = webTextTable.getWebTextTableFrame().getFooters();
            tableCellLocators = webTextTable.getWebTextTableFrame().getFooterLocators();
        }
        HashMap<String, List<Method>> webChildElementMethods = new HashMap<String, List<Method>>();
        for (String tableColumnName : tableColumnNames) {
            Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
            List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(tableCellMappedBlockClass);
            webChildElementMethods.put(tableColumnName, childElementMethods);
        }
        if (TableSection.BODY == tableSection) {
            Iterator<String> iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)((Object)iterator.next());
                WebTableRow webMappedRowInstance = this.initializer.initWebTableRow();
                HashMap<String, WebBlock> tableCells = new HashMap<String, WebBlock>();
                for (String tableColumnName : tableColumnNames) {
                    Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
                    WebLocatorHolder tableCellLocator = tableCellLocators.get(tableColumnName);
                    DefaultWebTextBlock webMappedBlockInstance = (DefaultWebTextBlock)this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                    List methods = (List)webChildElementMethods.get(tableColumnName);
                    WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, methods);
                    ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                    WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                    parentLocators.add(tableCellRootLocator);
                    WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webMappedRowInstance, parentLocators);
                    DefaultWebTextBlock decoratedWebMappedBlockInstance = (DefaultWebTextBlock)this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                    tableCells.put(tableColumnName, decoratedWebMappedBlockInstance);
                }
                WebElementRegistry elementRegistry = WebElementRegistry.of(tableCells);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                WebLocatorHolder tableRowRootLocator = tableRowLocator.clone().setSingle(true).setIndex(index);
                parentLocators.add(tableRowRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTextTable, hash, parentLocators);
                DefaultWebTextBlock decoratedWebMappedRowInstance = this.decorator.decorateMappedWebBlockInstance(webMappedRowInstance, DefaultWebTextBlock.class, elementRegistry, parentInfo);
                webMappedRows.put(index, decoratedWebMappedRowInstance);
            }
        } else {
            WebTableRow webMappedRowInstance = this.initializer.initWebTableRow();
            HashMap<String, WebBlock> tableCells = new HashMap<String, WebBlock>();
            for (String tableColumnName : tableColumnNames) {
                Class<? extends WebChildElement> tableCellMappedBlockClass = tableCellFrames.get(tableColumnName).getElementIdentifier().getElementType();
                WebLocatorHolder tableCellLocator = tableCellLocators.get(tableColumnName);
                DefaultWebTextBlock webMappedBlockInstance = (DefaultWebTextBlock)this.initializer.initMappedWebBlock(tableCellMappedBlockClass);
                List methods = (List)webChildElementMethods.get(tableColumnName);
                WebElementRegistry elementRegistry = this.createWebChildElementRegistry(webMappedBlockInstance, methods);
                ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
                WebLocatorHolder tableCellRootLocator = tableCellLocator.clone();
                parentLocators.add(tableCellRootLocator);
                WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webMappedRowInstance, parentLocators);
                DefaultWebTextBlock decoratedWebMappedBlockInstance = (DefaultWebTextBlock)this.decorator.decorateMappedWebBlockInstance(webMappedBlockInstance, tableCellMappedBlockClass, elementRegistry, parentInfo);
                tableCells.put(tableColumnName, decoratedWebMappedBlockInstance);
            }
            WebElementRegistry elementRegistry = WebElementRegistry.of(tableCells);
            ArrayDeque<WebLocatorHolder> parentLocators = new ArrayDeque<WebLocatorHolder>();
            WebLocatorHolder tableRowRootLocator = tableRowLocator.clone();
            parentLocators.add(tableRowRootLocator);
            WebParentHolderForStructuralElement parentInfo = WebParentHolderForStructuralElement.of(webTextTable, hash, parentLocators);
            DefaultWebTextBlock decoratedWebMappedRowInstance = this.decorator.decorateMappedWebBlockInstance(webMappedRowInstance, DefaultWebTextBlock.class, elementRegistry, parentInfo);
            webMappedRows.put(-1, decoratedWebMappedRowInstance);
        }
        return webMappedRows;
    }

    @NotNull
    protected WebElementRegistry createWebChildElementRegistry(@NotNull WebParentElement parent, @NotNull List<Method> parentMethods) {
        List<WebChildElement> childElements = parentMethods.stream().map(childElementMethod -> {
            Class<?> childElementClass = childElementMethod.getReturnType();
            if (WebBlock.class.isAssignableFrom(childElementClass)) {
                return this.createWebBlock(parent, (Method)childElementMethod);
            }
            return this.createWebChildElement(parent, (Method)childElementMethod);
        }).collect(Collectors.toList());
        return WebElementRegistry.of(childElements);
    }
}

