/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory;

import io.perfeccionista.framework.exceptions.ElementImplementationNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.measurements.Order;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebBlockImpl;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.WebPageImpl;
import io.perfeccionista.framework.pagefactory.elements.WebTableRow;
import io.perfeccionista.framework.pagefactory.elements.WebTableRowImpl;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.pagefactory.factory.proxy.UnimplementedWebElementMethodInvocationHandler;
import io.perfeccionista.framework.pagefactory.factory.proxy.WebChildElementCallbackFilter;
import io.perfeccionista.framework.pagefactory.factory.proxy.WebParentElementCallbackFilter;
import io.perfeccionista.framework.pagefactory.factory.proxy.WebParentElementInvocationHandler;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.lang.reflect.Modifier;
import java.util.Deque;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.jetbrains.annotations.NotNull;

public class WebElementInitializer {
    private final WebPageFactoryPreferences configuration;

    public WebElementInitializer(@NotNull WebPageFactoryPreferences configuration) {
        this.configuration = configuration;
    }

    @NotNull
    public WebPage initWebPageInstance(@NotNull Class<? extends WebPage> webPageClass) {
        Class<? extends WebPageImpl> webPageImplementation = this.configuration.getWebPageImplementation();
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{webPageClass});
        enhancer.setSuperclass(webPageImplementation);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new WebParentElementInvocationHandler()});
        enhancer.setCallbackFilter((CallbackFilter)new WebParentElementCallbackFilter(webPageImplementation));
        return (WebPage)enhancer.create();
    }

    @NotNull
    public <T extends WebBlock> T initWebBlock(@NotNull Class<T> webBlockClass) {
        Class<? extends WebBlockImpl> webBlockImplementation = this.configuration.getWebBlockImplementation();
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{webBlockClass});
        enhancer.setSuperclass(webBlockImplementation);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new WebParentElementInvocationHandler()});
        enhancer.setCallbackFilter((CallbackFilter)new WebParentElementCallbackFilter(webBlockImplementation));
        return (T)((WebBlock)enhancer.create());
    }

    @NotNull
    public <T extends WebBlock> T initMappedWebBlock(@NotNull Class<T> webBlockClass) {
        Class<? extends WebBlockImpl> webBlockImplementation = this.configuration.getMappedWebBlockImplementation();
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{webBlockClass});
        enhancer.setSuperclass(webBlockImplementation);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new WebParentElementInvocationHandler()});
        enhancer.setCallbackFilter((CallbackFilter)new WebParentElementCallbackFilter(webBlockImplementation));
        return (T)((WebBlock)enhancer.create());
    }

    @NotNull
    public WebTableRow initWebTableRow() {
        Class<? extends WebTableRowImpl> webTableRowImplementation = this.configuration.getWebTableRowImplementation();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(webTableRowImplementation);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new WebParentElementInvocationHandler()});
        enhancer.setCallbackFilter((CallbackFilter)new WebParentElementCallbackFilter(webTableRowImplementation));
        return (WebTableRow)enhancer.create();
    }

    @NotNull
    public WebChildElement initWebChildElement(@NotNull Class<? extends WebChildElement> webChildElementClass) {
        if (!Modifier.isInterface(webChildElementClass.getModifiers())) {
            if (Modifier.isAbstract(webChildElementClass.getModifiers()) || webChildElementClass.isEnum()) {
                throw ElementImplementationNotFound.exception((String)PageFactoryApiMessages.ELEMENT_IMPLEMENTATION_CANT_BE_ABSTRACT.getMessage(new Object[]{webChildElementClass.getCanonicalName()}));
            }
            return (WebChildElement)ReflectionUtilsForClasses.newInstance(webChildElementClass, (Object[])new Object[0]);
        }
        Class<? extends WebChildElement> webChildElementImplementation = this.configuration.getWebElementImplementation(webChildElementClass);
        if (webChildElementImplementation != null) {
            return (WebChildElement)ReflectionUtilsForClasses.newInstance(webChildElementImplementation, (Object[])new Object[0]);
        }
        Class<? extends WebChildElement> interfaceImplementationClass = this.findAncestorInterfaceImplementation(webChildElementClass);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{webChildElementClass});
        enhancer.setSuperclass(interfaceImplementationClass);
        enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new UnimplementedWebElementMethodInvocationHandler()});
        enhancer.setCallbackFilter((CallbackFilter)new WebChildElementCallbackFilter(interfaceImplementationClass));
        return (WebChildElement)enhancer.create();
    }

    @NotNull
    protected Class<? extends WebChildElement> findAncestorInterfaceImplementation(@NotNull Class<? extends WebChildElement> webChildElementClass) {
        Deque inheritedInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElement.class, webChildElementClass, (Order)Order.DESC);
        for (Class inheritedInterface : inheritedInterfaces) {
            Class<? extends WebChildElement> elementImplementation = this.configuration.getWebElementImplementation(inheritedInterface);
            if (null == elementImplementation) continue;
            return elementImplementation;
        }
        throw ElementImplementationNotFound.exception((String)PageFactoryApiMessages.ELEMENT_IMPLEMENTATION_NOT_FOUND.getMessage(new Object[]{webChildElementClass.getCanonicalName()}));
    }
}

