/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory;

import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.registry.WebElementRegistry;
import io.perfeccionista.framework.pagefactory.factory.WebElementFrameDecorator;
import io.perfeccionista.framework.pagefactory.factory.WebElementFrameInitializer;
import io.perfeccionista.framework.utils.WebElementUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class WebElementFrameFactory {
    private WebElementFrameFactory() {
    }

    @NotNull
    public static <T extends WebBlock> T createWebBlockFrame(@NotNull Class<T> webMappedBlockClass) {
        T webMappedBlockFrame = WebElementFrameInitializer.initWebBlockFrame(webMappedBlockClass);
        List<Method> webChildElementMethods = WebElementUtils.getWebChildElementMethods(webMappedBlockClass);
        WebElementRegistry webElementRegistry = WebElementFrameFactory.createWebChildElementFrameRegistry(webChildElementMethods);
        return WebElementFrameDecorator.decorateWebMappedBlockFrameInstance(webMappedBlockFrame, webElementRegistry, webMappedBlockClass);
    }

    @NotNull
    protected static WebElementRegistry createWebChildElementFrameRegistry(@NotNull List<Method> parentMethods) {
        List<WebChildElement> childElements = parentMethods.stream().map(childElementMethod -> {
            Class<?> childElementType = childElementMethod.getReturnType();
            if (WebBlock.class.isAssignableFrom(childElementType)) {
                Class<?> webBlockType = childElementType;
                Object webBlockFrameInstance = WebElementFrameInitializer.initWebBlockFrame(webBlockType);
                List<Method> childElementMethods = WebElementUtils.getWebChildElementMethods(webBlockType);
                WebElementRegistry elementRegistry = WebElementFrameFactory.createWebChildElementFrameRegistry(childElementMethods);
                return WebElementFrameDecorator.decorateWebBlockFrameInstance(webBlockFrameInstance, elementRegistry, webBlockType, childElementMethod);
            }
            WebChildElement childElementFrameInstance = WebElementFrameInitializer.initWebChildElementFrame(childElementType);
            return WebElementFrameDecorator.decorateWebChildElementFrameInstance(childElementFrameInstance, childElementType, childElementMethod);
        }).collect(Collectors.toList());
        return WebElementRegistry.of(childElements);
    }
}

