/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.factory;

import io.perfeccionista.framework.name.WebChildElementIdentifier;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.registry.WebElementRegistry;
import io.perfeccionista.framework.pagefactory.factory.handlers.WebElementNameHandler;
import io.perfeccionista.framework.utils.ReflectionUtilsForFields;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class WebElementFrameDecorator {
    public static final String ELEMENT_IDENTIFIER_FIELD = "elementIdentifier";
    public static final String ELEMENT_REGISTRY_FIELD = "elementRegistry";
    public static final String ELEMENT_CLASS_FIELD = "elementClass";

    private WebElementFrameDecorator() {
    }

    @NotNull
    public static <T extends WebBlock> T decorateWebMappedBlockFrameInstance(@NotNull T webMappedBlockFrameInstance, @NotNull WebElementRegistry elementRegistry, @NotNull Class<T> webMappedBlockClass) {
        ReflectionUtilsForFields.writeField((String)ELEMENT_REGISTRY_FIELD, webMappedBlockFrameInstance, (Object)elementRegistry);
        ReflectionUtilsForFields.writeField((String)ELEMENT_CLASS_FIELD, webMappedBlockFrameInstance, webMappedBlockClass);
        return webMappedBlockFrameInstance;
    }

    @NotNull
    public static WebBlock decorateWebBlockFrameInstance(@NotNull WebBlock webBlockFrameInstance, @NotNull WebElementRegistry elementRegistry, @NotNull Class<? extends WebBlock> webBlockClass, @NotNull Method webBlockMethod) {
        WebElementFrameDecorator.decorateWebChildElementFrameInstance(webBlockFrameInstance, webBlockClass, webBlockMethod);
        ReflectionUtilsForFields.writeField((String)ELEMENT_REGISTRY_FIELD, (Object)webBlockFrameInstance, (Object)elementRegistry);
        return webBlockFrameInstance;
    }

    @NotNull
    public static WebChildElement decorateWebChildElementFrameInstance(@NotNull WebChildElement webChildElementFrameInstance, @NotNull Class<? extends WebChildElement> webChildElementClass, @NotNull Method webChildElementMethod) {
        WebChildElementIdentifier identifier = WebChildElementIdentifier.of(WebElementNameHandler.extractNames(webChildElementFrameInstance, webChildElementMethod), webChildElementMethod);
        ReflectionUtilsForFields.writeField((String)ELEMENT_IDENTIFIER_FIELD, (Object)webChildElementFrameInstance, (Object)identifier);
        ReflectionUtilsForFields.writeField((String)ELEMENT_CLASS_FIELD, (Object)webChildElementFrameInstance, webChildElementClass);
        return webChildElementFrameInstance;
    }
}

