/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.texttable;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilter;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilterBuilder;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import io.perfeccionista.framework.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextTableSingleIndexedResult<T>
implements WebSingleIndexedResult<T, WebTextTable> {
    private final WebTextTable element;
    private final WebTextTableFilterBuilder filterBuilder;
    private final WebTextTableValueExtractor<T> extractor;

    private WebTextTableSingleIndexedResult(WebTextTable element, WebTextTableFilterBuilder filterBuilder, WebTextTableValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebTextTableSingleIndexedResult<T> of(@NotNull WebTextTable element, @NotNull WebTextTableFilterBuilder filterBuilder, @NotNull WebTextTableValueExtractor<T> extractor) {
        return new WebTextTableSingleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebTextTableSingleIndexedResult<T> of(@NotNull WebTextTable element, @NotNull WebTextTableValueExtractor<T> extractor) {
        return new WebTextTableSingleIndexedResult<T>(element, Web.emptyWebTextTableFilter(), extractor);
    }

    @Override
    @NotNull
    public WebTextTable getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public T getResult() {
        WebTextTableFilter webTextTableFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return extractedValues.values().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    @NotNull
    public T getNotNullResult() {
        WebTextTableFilter webTextTableFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            Map.Entry extractedEntry = (Map.Entry)extractedValues.entrySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
            Object maybeNullValue = extractedEntry.getValue();
            if (Objects.isNull(maybeNullValue)) {
                throw ResultVerification.assertionError((String)PageFactoryApiMessages.FILTERED_ELEMENT_CONTAINS_NULL_RESULT.getMessage(new Object[]{extractedEntry.getKey()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
            return maybeNullValue;
        });
    }

    @Override
    public int getIndex() {
        WebTextTableFilter webTextTableFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetIndex", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return (Integer)extractedValues.keySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    public WebSingleIndexedResult<T, WebTextTable> should(WebMultipleIndexedResultMatcher<T> matcher) {
        WebTextTableMultipleIndexedResult<T> result = WebTextTableMultipleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
        matcher.check(result);
        return this;
    }
}

