/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.texttable;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.DefaultWebTextBlock;
import io.perfeccionista.framework.pagefactory.elements.WebLink;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.base.TableSection;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilter;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetTextOperationType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebTextTableCellTextValueExtractor
implements WebTextTableValueExtractor<String> {
    private TableSection section = TableSection.BODY;
    private final String columnName;

    public WebTextTableCellTextValueExtractor(@NotNull String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Map<Integer, String> extractValues(@NotNull WebTextTableFilter filter) {
        FilterResult filterResult = filter.getFilterResult();
        Set indexes = filterResult.getIndexes();
        String hash = filterResult.getHash();
        WebTextTable element = (WebTextTable)filter.getElement();
        WebLocatorHolder tableRowLocator = element.getRequiredLocator("TBODY");
        WebLocatorHolder tableCellLocator = element.getWebTextTableFrame().getRequiredBodyLocator(this.columnName);
        DefaultWebTextBlock tableCellBlock = element.getWebTextTableFrame().getRequiredBodyMappedBlock(this.columnName);
        if (TableSection.HEADER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTextTableFrame().getRequiredHeaderLocator(this.columnName);
            tableCellBlock = element.getWebTextTableFrame().getRequiredHeaderMappedBlock(this.columnName);
        }
        if (TableSection.FOOTER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTextTableFrame().getRequiredFooterLocator(this.columnName);
            tableCellBlock = element.getWebTextTableFrame().getRequiredFooterMappedBlock(this.columnName);
        }
        WebLocatorChain tableLocatorChain = element.getLocatorChain().updateLastLocator(locator -> locator.setCalculateHash(true)).updateLastLocator(locator -> locator.setExpectedHash(hash));
        if (TableSection.BODY == this.section) {
            tableLocatorChain.addLastLocator(tableRowLocator).updateLastLocator(locator -> locator.setIndexes(indexes)).addLastLocator(tableCellLocator);
        } else {
            tableLocatorChain.addLastLocator(tableRowLocator).addLastLocator(tableCellLocator);
        }
        WebLink elementToExtractValue = tableCellBlock.textLink();
        WebGetTextOperationType operationType = WebGetTextOperationType.of(elementToExtractValue);
        WebElementOperation<String> operation = WebElementOperationHandler.of(elementToExtractValue, operationType, "TEXT").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        return operationResult.getResults();
    }

    public WebTextTableCellTextValueExtractor fromHeader() {
        this.section = TableSection.HEADER;
        return this;
    }

    public WebTextTableCellTextValueExtractor fromFooter() {
        this.section = TableSection.FOOTER;
        return this;
    }
}

