/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.texttable;

import io.perfeccionista.framework.pagefactory.WebPageService;
import io.perfeccionista.framework.pagefactory.elements.WebLink;
import io.perfeccionista.framework.pagefactory.elements.WebTextTable;
import io.perfeccionista.framework.pagefactory.elements.base.TableSection;
import io.perfeccionista.framework.pagefactory.extractor.texttable.WebTextTableValueExtractor;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.texttable.WebTextTableFilter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WebTextTableCellElementExtractor
implements WebTextTableValueExtractor<WebLink> {
    private TableSection section = TableSection.BODY;
    private final String columnName;

    public WebTextTableCellElementExtractor(@NotNull String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Map<Integer, WebLink> extractValues(@NotNull WebTextTableFilter filter) {
        FilterResult filterResult = filter.getFilterResult();
        WebTextTable element = (WebTextTable)filter.getElement();
        HashMap<Integer, WebLink> extractedElements = new HashMap<Integer, WebLink>();
        WebPageFactory webPageFactory = ((WebPageService)element.getEnvironment().getService(WebPageService.class)).getWebPageFactory();
        webPageFactory.createWebTextTableCells(element, this.columnName, this.section, filterResult).forEach((index, webMappedBlock) -> extractedElements.put((Integer)index, webMappedBlock.textLink()));
        return extractedElements;
    }

    public WebTextTableCellElementExtractor fromHeader() {
        this.section = TableSection.HEADER;
        return this;
    }

    public WebTextTableCellElementExtractor fromFooter() {
        this.section = TableSection.FOOTER;
        return this;
    }
}

