/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.textlist;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilter;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilterBuilder;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import io.perfeccionista.framework.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTextListSingleIndexedResult<T>
implements WebSingleIndexedResult<T, WebTextList> {
    private final WebTextList element;
    private final WebTextListFilterBuilder filterBuilder;
    private final WebTextListBlockValueExtractor<T> extractor;

    private WebTextListSingleIndexedResult(WebTextList element, WebTextListFilterBuilder filterBuilder, WebTextListBlockValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebTextListSingleIndexedResult<T> of(@NotNull WebTextList element, @NotNull WebTextListFilterBuilder filterBuilder, @NotNull WebTextListBlockValueExtractor<T> extractor) {
        return new WebTextListSingleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebTextListSingleIndexedResult<T> of(@NotNull WebTextList element, @NotNull WebTextListBlockValueExtractor<T> extractor) {
        return new WebTextListSingleIndexedResult<T>(element, Web.emptyWebTextListFilter(), extractor);
    }

    @Override
    @NotNull
    public WebTextList getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public T getResult() {
        WebTextListFilter webTextListFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return extractedValues.values().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    @NotNull
    public T getNotNullResult() {
        WebTextListFilter webTextListFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            Map.Entry extractedEntry = (Map.Entry)extractedValues.entrySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
            Object maybeNullValue = extractedEntry.getValue();
            if (Objects.isNull(maybeNullValue)) {
                throw ResultVerification.assertionError((String)PageFactoryApiMessages.FILTERED_ELEMENT_CONTAINS_NULL_RESULT.getMessage(new Object[]{extractedEntry.getKey()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
            return maybeNullValue;
        });
    }

    @Override
    public int getIndex() {
        WebTextListFilter webTextListFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetIndex", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTextListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return (Integer)extractedValues.keySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    public WebSingleIndexedResult<T, WebTextList> should(WebMultipleIndexedResultMatcher<T> matcher) {
        WebTextListMultipleIndexedResult<T> result = WebTextListMultipleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
        matcher.check(result);
        return this;
    }
}

