/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.textlist;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTextList;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.textlist.WebTextListSingleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilter;
import io.perfeccionista.framework.pagefactory.filter.textlist.WebTextListFilterBuilder;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WebTextListMultipleIndexedResult<T>
implements WebMultipleIndexedResult<T, WebTextList> {
    private final WebTextList element;
    private final WebTextListFilterBuilder filterBuilder;
    private final WebTextListBlockValueExtractor<T> extractor;

    private WebTextListMultipleIndexedResult(WebTextList element, WebTextListFilterBuilder filterBuilder, WebTextListBlockValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebTextListMultipleIndexedResult<T> of(@NotNull WebTextList element, @NotNull WebTextListFilterBuilder filterBuilder, @NotNull WebTextListBlockValueExtractor<T> extractor) {
        return new WebTextListMultipleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebTextListMultipleIndexedResult<T> of(@NotNull WebTextList element, @NotNull WebTextListBlockValueExtractor<T> extractor) {
        return new WebTextListMultipleIndexedResult<T>(element, Web.emptyWebTextListFilter(), extractor);
    }

    @Override
    @NotNull
    public WebTextList getElement() {
        return this.element;
    }

    @Override
    public Map<Integer, T> getResults() {
        WebTextListFilter webTextListFilter = this.filterBuilder.build(this.element);
        return (Map)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValues", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> this.extractor.extractValues(webTextListFilter));
    }

    @Override
    public int getSize() {
        WebTextListFilter webTextListFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetSize", (Object[])new Object[]{this.element, this.filterBuilder}), () -> webTextListFilter.getFilterResult().getIndexes().size());
    }

    @Override
    public WebMultipleIndexedResult<T, WebTextList> should(WebMultipleIndexedResultMatcher<T> matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<T, WebTextList> singleResult() {
        return WebTextListSingleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
    }
}

