/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.table;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilter;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilterBuilder;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import io.perfeccionista.framework.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebTableSingleIndexedResult<T>
implements WebSingleIndexedResult<T, WebTable> {
    private final WebTable element;
    private final WebTableFilterBuilder filterBuilder;
    private final WebTableValueExtractor<T> extractor;

    private WebTableSingleIndexedResult(WebTable element, WebTableFilterBuilder filterBuilder, WebTableValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebTableSingleIndexedResult<T> of(@NotNull WebTable element, @NotNull WebTableFilterBuilder filterBuilder, @NotNull WebTableValueExtractor<T> extractor) {
        return new WebTableSingleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebTableSingleIndexedResult<T> of(@NotNull WebTable element, @NotNull WebTableValueExtractor<T> extractor) {
        return new WebTableSingleIndexedResult<T>(element, Web.emptyWebTableFilter(), extractor);
    }

    @Override
    @NotNull
    public WebTable getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public T getResult() {
        WebTableFilter webTableFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return extractedValues.values().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    @NotNull
    public T getNotNullResult() {
        WebTableFilter webTableFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            Map.Entry extractedEntry = (Map.Entry)extractedValues.entrySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
            Object maybeNullValue = extractedEntry.getValue();
            if (Objects.isNull(maybeNullValue)) {
                throw ResultVerification.assertionError((String)PageFactoryApiMessages.FILTERED_ELEMENT_CONTAINS_NULL_RESULT.getMessage(new Object[]{extractedEntry.getKey()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
            return maybeNullValue;
        });
    }

    @Override
    public int getIndex() {
        WebTableFilter webTableFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetIndex", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webTableFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return (Integer)extractedValues.keySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    public WebSingleIndexedResult<T, WebTable> should(WebMultipleIndexedResultMatcher<T> matcher) {
        WebTableMultipleIndexedResult<T> result = WebTableMultipleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
        matcher.check(result);
        return this;
    }
}

