/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.table;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableSingleIndexedResult;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilter;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilterBuilder;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WebTableMultipleIndexedResult<T>
implements WebMultipleIndexedResult<T, WebTable> {
    private final WebTable element;
    private final WebTableFilterBuilder filterBuilder;
    private final WebTableValueExtractor<T> extractor;

    private WebTableMultipleIndexedResult(WebTable element, WebTableFilterBuilder filterBuilder, WebTableValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebTableMultipleIndexedResult<T> of(@NotNull WebTable element, @NotNull WebTableFilterBuilder filterBuilder, @NotNull WebTableValueExtractor<T> extractor) {
        return new WebTableMultipleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebTableMultipleIndexedResult<T> of(@NotNull WebTable element, @NotNull WebTableValueExtractor<T> extractor) {
        return new WebTableMultipleIndexedResult<T>(element, Web.emptyWebTableFilter(), extractor);
    }

    @Override
    @NotNull
    public WebTable getElement() {
        return this.element;
    }

    @Override
    public Map<Integer, T> getResults() {
        return (Map)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValues", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> this.extractor.extractValues(this.filterBuilder.build(this.element)));
    }

    @Override
    public int getSize() {
        WebTableFilter webTableFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetSize", (Object[])new Object[]{this.element, this.filterBuilder}), () -> webTableFilter.getFilterResult().getIndexes().size());
    }

    @Override
    public WebMultipleIndexedResult<T, WebTable> should(WebMultipleIndexedResultMatcher<T> matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<T, WebTable> singleResult() {
        return WebTableSingleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
    }
}

