/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.table;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.TableSection;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsEnabledAvailable;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilter;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsEnabledOperationType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebTableCellElementEnabledMarkExtractor
implements WebTableValueExtractor<Boolean> {
    private TableSection section = TableSection.BODY;
    private final String columnName;
    private final WebIsEnabledAvailable elementFrame;
    private final String elementPath;

    public WebTableCellElementEnabledMarkExtractor(@NotNull String columnName, @NotNull WebIsEnabledAvailable elementFrame) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = elementFrame;
    }

    public WebTableCellElementEnabledMarkExtractor(@NotNull String columnName, @NotNull String elementPath) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
    }

    @Override
    public Map<Integer, Boolean> extractValues(@NotNull WebTableFilter filter) {
        FilterResult filterResult = filter.getFilterResult();
        Set indexes = filterResult.getIndexes();
        String hash = filterResult.getHash();
        WebTable element = (WebTable)filter.getElement();
        WebLocatorHolder tableRowLocator = element.getRequiredLocator("TBODY");
        WebLocatorHolder tableCellLocator = element.getWebTableFrame().getRequiredBodyLocator(this.columnName);
        WebBlock tableCellBlock = element.getWebTableFrame().getRequiredBodyMappedBlock(this.columnName);
        if (TableSection.HEADER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTableFrame().getRequiredHeaderLocator(this.columnName);
            tableCellBlock = element.getWebTableFrame().getRequiredHeaderMappedBlock(this.columnName);
        }
        if (TableSection.FOOTER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTableFrame().getRequiredFooterLocator(this.columnName);
            tableCellBlock = element.getWebTableFrame().getRequiredFooterMappedBlock(this.columnName);
        }
        WebLocatorChain tableLocatorChain = element.getLocatorChain().updateLastLocator(locator -> locator.setCalculateHash(true)).updateLastLocator(locator -> locator.setExpectedHash(hash));
        if (TableSection.BODY == this.section) {
            tableLocatorChain.addLastLocator(tableRowLocator).updateLastLocator(locator -> locator.setIndexes(indexes)).addLastLocator(tableCellLocator);
        } else {
            tableLocatorChain.addLastLocator(tableRowLocator).addLastLocator(tableCellLocator);
        }
        WebIsEnabledAvailable elementToExtractValue = this.elementPath != null ? tableCellBlock.getElementRegistry().getRequiredElementByPath(this.elementPath, WebIsEnabledAvailable.class) : tableCellBlock.getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod(), WebIsEnabledAvailable.class);
        WebGetIsEnabledOperationType operationType = WebGetIsEnabledOperationType.of(elementToExtractValue);
        WebElementOperation<Boolean> operation = WebElementOperationHandler.of(elementToExtractValue, operationType, "ENABLED").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        return operationResult.getResults();
    }

    public WebTableCellElementEnabledMarkExtractor fromHeader() {
        this.section = TableSection.HEADER;
        return this;
    }

    public WebTableCellElementEnabledMarkExtractor fromFooter() {
        this.section = TableSection.FOOTER;
        return this;
    }
}

