/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.table;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.base.TableSection;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.extractor.table.WebTableValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.table.WebTableFilter;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsDisplayedOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebTableCellElementComponentDisplayedMarkExtractor
implements WebTableValueExtractor<Boolean> {
    private TableSection section = TableSection.BODY;
    private final String columnName;
    private final WebChildElement elementFrame;
    private final String elementPath;
    private final String componentName;

    public WebTableCellElementComponentDisplayedMarkExtractor(@NotNull String columnName, @NotNull String elementPath, @NotNull String componentName) {
        this.columnName = columnName;
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.componentName = componentName;
    }

    public WebTableCellElementComponentDisplayedMarkExtractor(@NotNull String columnName, @NotNull WebChildElement elementFrame, @NotNull String componentName) {
        this.columnName = columnName;
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.componentName = componentName;
    }

    @Override
    public Map<Integer, Boolean> extractValues(@NotNull WebTableFilter filter) {
        FilterResult filterResult = filter.getFilterResult();
        Set indexes = filterResult.getIndexes();
        String hash = filterResult.getHash();
        WebTable element = (WebTable)filter.getElement();
        WebLocatorHolder tableRowLocator = element.getRequiredLocator("TBODY");
        WebLocatorHolder tableCellLocator = element.getWebTableFrame().getRequiredBodyLocator(this.columnName);
        WebBlock tableCellBlock = element.getWebTableFrame().getRequiredBodyMappedBlock(this.columnName);
        if (TableSection.HEADER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTableFrame().getRequiredHeaderLocator(this.columnName);
            tableCellBlock = element.getWebTableFrame().getRequiredHeaderMappedBlock(this.columnName);
        }
        if (TableSection.FOOTER == this.section) {
            tableRowLocator = element.getRequiredLocator("THEAD");
            tableCellLocator = element.getWebTableFrame().getRequiredFooterLocator(this.columnName);
            tableCellBlock = element.getWebTableFrame().getRequiredFooterMappedBlock(this.columnName);
        }
        WebLocatorChain tableLocatorChain = element.getLocatorChain().updateLastLocator(locator -> locator.setCalculateHash(true)).updateLastLocator(locator -> locator.setExpectedHash(hash));
        if (TableSection.BODY == this.section) {
            tableLocatorChain.addLastLocator(tableRowLocator).updateLastLocator(locator -> locator.setIndexes(indexes)).addLastLocator(tableCellLocator);
        } else {
            tableLocatorChain.addLastLocator(tableRowLocator).addLastLocator(tableCellLocator);
        }
        WebChildElement elementToExtractValue = this.elementPath != null ? tableCellBlock.getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : tableCellBlock.getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod());
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(elementToExtractValue);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(elementToExtractValue, operationType, this.componentName).getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        return operationResult.getResults();
    }

    public WebTableCellElementComponentDisplayedMarkExtractor fromHeader() {
        this.section = TableSection.HEADER;
        return this;
    }

    public WebTableCellElementComponentDisplayedMarkExtractor fromFooter() {
        this.section = TableSection.FOOTER;
        return this;
    }
}

